/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.function;

import java.util.Comparator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.dongliu.commons.Exceptions;
import net.dongliu.commons.function.EBiConsumer;
import net.dongliu.commons.function.EBiFunction;
import net.dongliu.commons.function.EBiPredicate;
import net.dongliu.commons.function.EComparator;
import net.dongliu.commons.function.EConsumer;
import net.dongliu.commons.function.EFunction;
import net.dongliu.commons.function.EPredicate;
import net.dongliu.commons.function.ERunnable;
import net.dongliu.commons.function.ESupplier;

public class Unchecked {
    public static <T> T call(ESupplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            throw Exceptions.uncheck(e);
        }
    }

    public static void run(ERunnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            throw Exceptions.uncheck(e);
        }
    }

    public static Runnable runnable(ERunnable runnable) {
        return () -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                throw Exceptions.uncheck(e);
            }
        };
    }

    public static <T> Comparator<T> comparator(EComparator<T> comparator) {
        return (v1, v2) -> {
            try {
                return comparator.compare(v1, v2);
            }
            catch (Exception e) {
                throw Exceptions.uncheck(e);
            }
        };
    }

    public static <T> Supplier<T> supplier(ESupplier<T> supplier) {
        return () -> {
            try {
                return supplier.get();
            }
            catch (Exception e) {
                throw Exceptions.uncheck(e);
            }
        };
    }

    public static <T> Consumer<T> consumer(EConsumer<T> consumer) {
        return value -> {
            try {
                consumer.accept(value);
            }
            catch (Exception e) {
                throw Exceptions.uncheck(e);
            }
        };
    }

    public static <T> Predicate<T> predicate(EPredicate<T> predicate) {
        return value -> {
            try {
                return predicate.test(value);
            }
            catch (Exception e) {
                throw Exceptions.uncheck(e);
            }
        };
    }

    public static <T, R> Function<T, R> function(EFunction<T, R> function) {
        return value -> {
            try {
                return function.apply(value);
            }
            catch (Exception e) {
                throw Exceptions.uncheck(e);
            }
        };
    }

    public static <T> UnaryOperator<T> unaryOperator(EFunction<T, T> function) {
        return value -> {
            try {
                return function.apply(value);
            }
            catch (Exception e) {
                throw Exceptions.uncheck(e);
            }
        };
    }

    public static <T, U> BiConsumer<T, U> biConsumer(EBiConsumer<T, U> consumer) {
        return (v1, v2) -> {
            try {
                consumer.accept(v1, v2);
            }
            catch (Exception e) {
                throw Exceptions.uncheck(e);
            }
        };
    }

    public static <T, U> BiPredicate<T, U> biPredicate(EBiPredicate<T, U> predicate) {
        return (v1, v2) -> {
            try {
                return predicate.test(v1, v2);
            }
            catch (Exception e) {
                throw Exceptions.uncheck(e);
            }
        };
    }

    public static <T, U, R> BiFunction<T, U, R> biFunction(EBiFunction<T, U, R> function) {
        return (v1, v2) -> {
            try {
                return function.apply(v1, v2);
            }
            catch (Exception e) {
                throw Exceptions.uncheck(e);
            }
        };
    }

    public static <T> BinaryOperator<T> binaryOperator(EBiFunction<T, T, T> function) {
        return (v1, v2) -> {
            try {
                return function.apply(v1, v2);
            }
            catch (Exception e) {
                throw Exceptions.uncheck(e);
            }
        };
    }
}

