/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dongliu.commons.BinarySize;
import net.dongliu.commons.io.Closables;

@ParametersAreNonnullByDefault
public class InputOutputs {
    private static final int BUFFER_SIZE = (int)BinarySize.kilobyte(8L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[BUFFER_SIZE];
        try {
            int read;
            while ((read = input.read(buffer)) != -1) {
                output.write(buffer, 0, read);
            }
        }
        finally {
            Closables.closeQuietly((AutoCloseable)input);
        }
    }

    public static byte[] readAll(InputStream input) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            InputOutputs.copy(input, bos);
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readAll(InputStream input, int maxSize) throws IOException {
        byte[] data = new byte[maxSize];
        int offset = 0;
        try {
            int read;
            while ((read = input.read(data, offset, BUFFER_SIZE)) != -1) {
                offset += read;
            }
            if (offset < maxSize) {
                byte[] byArray = Arrays.copyOf(data, offset);
                return byArray;
            }
            byte[] byArray = data;
            return byArray;
        }
        finally {
            Closables.closeQuietly((AutoCloseable)input);
        }
    }

    public static int readAll(InputStream input, byte[] data) throws IOException {
        return InputOutputs.readAll(input, data, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readAll(InputStream input, byte[] data, int offset) throws IOException {
        int woffset = offset;
        try {
            int read;
            while ((read = input.read(data, woffset, BUFFER_SIZE)) != -1) {
                woffset += read;
            }
            int n = woffset - offset;
            return n;
        }
        finally {
            Closables.closeQuietly((AutoCloseable)input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long skipAll(InputStream input) throws IOException {
        long count = 0L;
        try {
            long read;
            while ((read = input.skip(BUFFER_SIZE)) != 0L) {
                count += read;
            }
            byte[] buffer = new byte[BUFFER_SIZE];
            while ((read = (long)input.read(buffer)) != -1L) {
                count += read;
            }
        }
        finally {
            Closables.closeQuietly((AutoCloseable)input);
        }
        return count;
    }
}

