/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import net.dongliu.commons.BinarySize;
import net.dongliu.commons.io.Closables;

public class ReaderWriters {
    private static final int BUFFER_SIZE = (int)BinarySize.kilobyte(4L);

    public static void copy(Reader reader, Writer writer) throws IOException {
        char[] buffer = new char[BUFFER_SIZE];
        try (Reader r = reader;){
            int read;
            while ((read = r.read(buffer)) != -1) {
                writer.write(buffer, 0, read);
            }
        }
    }

    public static String readAll(Reader reader) throws IOException {
        try (StringWriter writer = new StringWriter();){
            ReaderWriters.copy(reader, writer);
            String string = writer.toString();
            return string;
        }
    }

    public static List<String> readLines(Reader reader) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader br = ReaderWriters.buffered(reader);){
            String line;
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
    }

    public static BufferedReader buffered(Reader reader) {
        if (reader instanceof BufferedReader) {
            return (BufferedReader)reader;
        }
        try {
            return new BufferedReader(reader);
        }
        catch (Throwable e) {
            Closables.close(reader, e);
            throw e;
        }
    }

    public static BufferedReader buffered(InputStream input, Charset charset) {
        InputStreamReader reader;
        try {
            reader = new InputStreamReader(input, charset);
        }
        catch (Throwable e) {
            Closables.close(input, e);
            throw e;
        }
        return ReaderWriters.buffered(reader);
    }

    public static long skipAll(Reader reader) throws IOException {
        long count = 0L;
        try (Reader r = reader;){
            long read;
            while ((read = r.skip(BUFFER_SIZE)) != 0L) {
                count += read;
            }
            char[] buffer = new char[BUFFER_SIZE];
            while ((read = (long)r.read(buffer)) != -1L) {
                count += read;
            }
        }
        return count;
    }
}

