/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.reflect;

import java.beans.PropertyDescriptor;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.annotation.Nullable;
import net.dongliu.commons.exception.ReflectException;
import net.dongliu.commons.reflect.Property;

public class BeanProperty
implements Property {
    private final PropertyDescriptor descriptor;
    @Nullable
    private final MethodHandle getter;
    @Nullable
    private final MethodHandle setter;

    public BeanProperty(PropertyDescriptor descriptor) {
        this.descriptor = Objects.requireNonNull(descriptor);
        this.getter = this.wrap(descriptor.getReadMethod());
        this.setter = this.wrap(descriptor.getWriteMethod());
    }

    public PropertyDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Nullable
    private MethodHandle wrap(@Nullable Method method) {
        if (method == null) {
            return null;
        }
        method.setAccessible(true);
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            return lookup.unreflect(method);
        }
        catch (IllegalAccessException e) {
            throw new ReflectException(e);
        }
    }

    @Override
    public boolean canRead() {
        return this.getter != null;
    }

    @Override
    public boolean canWrite() {
        return this.setter != null;
    }

    @Override
    public String name() {
        return this.descriptor.getName();
    }

    @Override
    public MethodHandle getter() {
        if (this.getter == null) {
            throw new ReflectException(new NoSuchMethodException());
        }
        return this.getter;
    }

    @Override
    public MethodHandle setter() {
        if (this.setter == null) {
            throw new ReflectException(new NoSuchMethodException());
        }
        return this.setter;
    }
}

