/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.reflect;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import net.dongliu.commons.collection.Lists;
import net.dongliu.commons.collection.Maps;
import net.dongliu.commons.collection.Pair;
import net.dongliu.commons.concurrent.WeakLoader;
import net.dongliu.commons.exception.ReflectException;

public class Beans {
    private static final WeakLoader<Pair<Class<?>, Class<?>>, BeanCopier> copierCacheLoader = WeakLoader.create(pair -> Beans.getBeanCopier((Class)pair.first(), (Class)pair.second()));
    private static final WeakLoader<Class<?>, List<PropertyDescriptor>> propertiesCacheLoader = WeakLoader.create(Beans::getPropertyDescriptors);

    public static Map<String, Object> toMap(Object bean) throws ReflectException {
        Map<String, Object> map = Maps.create();
        List<PropertyDescriptor> pds = Beans.getProperties(bean);
        for (PropertyDescriptor pd : pds) {
            String name = pd.getName();
            Method method = pd.getReadMethod();
            if (method == null) continue;
            Object value = Beans.readProperty(bean, pd);
            map.put(name, value);
        }
        return map;
    }

    public static <T> T copyFromMap(Map<String, ?> map, Class<T> cls) {
        T bean = Beans.newBean(cls);
        Beans.copyPropertiesFromMap(map, bean);
        return bean;
    }

    public static <T> void copyPropertiesFromMap(Map<String, ?> map, T bean) {
        List<PropertyDescriptor> pds = Beans.getProperties(bean);
        for (PropertyDescriptor pd : pds) {
            Method method;
            String name = pd.getName();
            if (!map.containsKey(name) || (method = pd.getWriteMethod()) == null) continue;
            Beans.writeProperty(bean, map.get(name), pd);
        }
    }

    public static <T> T copyBean(T bean) {
        Object newBean;
        try {
            newBean = bean.getClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ReflectException(e);
        }
        Beans.copyBeanProperties(bean, newBean);
        return bean;
    }

    public static void copyBeanProperties(Object src, Object dst) {
        Pair<Class<?>, Class<?>> key = Pair.of(src.getClass(), dst.getClass());
        BeanCopier beanCopier = copierCacheLoader.get(key);
        beanCopier.copy(src, dst);
    }

    private static BeanCopier getBeanCopier(Class<?> srcClass, Class<?> dstClass) {
        List<PropertyDescriptor> srcPdList = Beans.getClassProperties(srcClass);
        List<PropertyDescriptor> dstPdList = Beans.getClassProperties(dstClass);
        HashMap<String, PropertyDescriptor> dstMap = new HashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor pd : dstPdList) {
            Method dstMethod = pd.getWriteMethod();
            if (dstMethod == null) continue;
            String dstName = pd.getName();
            dstMap.put(dstName, pd);
        }
        ArrayList<Pair<Method, Method>> matchList = new ArrayList<Pair<Method, Method>>();
        for (PropertyDescriptor pd : srcPdList) {
            Class<?> dstType;
            Method srcMethod = pd.getReadMethod();
            if (srcMethod == null) continue;
            String srcName = pd.getName();
            Class<?> srcType = pd.getPropertyType();
            PropertyDescriptor dstPd = (PropertyDescriptor)dstMap.get(srcName);
            if (dstPd == null || !(dstType = dstPd.getPropertyType()).isAssignableFrom(srcType)) continue;
            matchList.add(Pair.of(pd.getReadMethod(), dstPd.getWriteMethod()));
        }
        return new BeanCopier(matchList);
    }

    public static String toString(Object bean) {
        StringJoiner joiner = new StringJoiner(", ", bean.getClass().getSimpleName() + "{", "}");
        for (Field field : Beans.getFields(bean.getClass())) {
            Object value;
            if (Modifier.isStatic(field.getModifiers())) continue;
            String name = field.getName();
            try {
                value = field.get(bean);
            }
            catch (IllegalAccessException e) {
                throw new ReflectException(e);
            }
            joiner.add(name + "=" + String.valueOf(value));
        }
        return joiner.toString();
    }

    private static <T> T newBean(Class<T> cls) {
        try {
            return cls.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ReflectException(e);
        }
    }

    public static List<PropertyDescriptor> getProperties(Object bean) {
        Class<?> cls = bean.getClass();
        return Beans.getClassProperties(cls);
    }

    public static List<Field> getFields(Class<?> cls) {
        Field[] fields;
        for (Field field : fields = cls.getDeclaredFields()) {
            field.setAccessible(true);
        }
        return Lists.of(fields);
    }

    public static List<PropertyDescriptor> getClassProperties(Class<?> cls) {
        return propertiesCacheLoader.get(cls);
    }

    private static List<PropertyDescriptor> getPropertyDescriptors(Class<?> cls) {
        PropertyDescriptor[] pds;
        try {
            pds = Introspector.getBeanInfo(cls).getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            throw new ReflectException(e);
        }
        List<PropertyDescriptor> propertyDescriptors = Lists.filter(Arrays.asList(pds), pd -> !pd.getName().equals("class"));
        propertyDescriptors = Lists.wrapImmutable(propertyDescriptors);
        return propertyDescriptors;
    }

    private static Object readProperty(Object bean, PropertyDescriptor pd) throws ReflectException {
        try {
            return pd.getReadMethod().invoke(bean, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ReflectException(e);
        }
    }

    private static void writeProperty(Object bean, Object value, PropertyDescriptor pd) {
        try {
            pd.getWriteMethod().invoke(bean, value);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ReflectException(e);
        }
    }

    static class BeanCopier {
        private final List<Pair<Method, Method>> matchList;

        BeanCopier(List<Pair<Method, Method>> matchList) {
            this.matchList = matchList;
        }

        void copy(Object src, Object dst) {
            for (Pair<Method, Method> pair : this.matchList) {
                try {
                    Object value = pair.first().invoke(src, new Object[0]);
                    pair.second().invoke(dst, value);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new ReflectException(e);
                }
            }
        }
    }
}

