/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.reflect;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import net.dongliu.commons.exception.Exceptions;
import net.dongliu.commons.exception.ReflectException;

public class ClassConstructor<T> {
    private final Constructor<T> constructor;
    private final MethodHandle methodHandle;

    public ClassConstructor(Constructor<T> constructor) {
        this.constructor = constructor;
        this.constructor.setAccessible(true);
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            this.methodHandle = lookup.unreflectConstructor(constructor);
        }
        catch (IllegalAccessException e) {
            throw new ReflectException(e);
        }
    }

    public T create(Object ... values) {
        try {
            return (T)this.methodHandle.invokeWithArguments(values);
        }
        catch (Throwable throwable) {
            throw Exceptions.sneakyThrow(throwable);
        }
    }

    public T create() {
        try {
            return (T)this.methodHandle.invoke();
        }
        catch (Throwable throwable) {
            throw Exceptions.sneakyThrow(throwable);
        }
    }
}

