/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.reflect;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Objects;
import javax.annotation.Nullable;
import net.dongliu.commons.exception.ReflectException;
import net.dongliu.commons.reflect.Property;

public class InstanceField
implements Property {
    private final Field field;
    @Nullable
    private final MethodHandle getter;
    @Nullable
    private final MethodHandle setter;

    public InstanceField(Field field) {
        Objects.requireNonNull(field);
        if (Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException("Field should not be static");
        }
        this.field = field;
        field.setAccessible(true);
        this.getter = this.getGetter(field);
        this.setter = this.getSetter(field);
    }

    private MethodHandle getGetter(Field field) {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            return lookup.unreflectGetter(field);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Nullable
    private MethodHandle getSetter(Field field) {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        if (!Modifier.isFinal(field.getModifiers())) {
            try {
                return lookup.unreflectSetter(field);
            }
            catch (IllegalAccessException e) {
                throw new ReflectException(e);
            }
        }
        return null;
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.field.getModifiers());
    }

    @Override
    public String name() {
        return this.field.getName();
    }

    @Override
    public MethodHandle getter() {
        return this.getter;
    }

    @Override
    public MethodHandle setter() {
        if (this.setter == null) {
            throw new ReflectException(new IllegalAccessException("Filed can not write"));
        }
        return this.setter;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return !Modifier.isFinal(this.field.getModifiers());
    }
}

