/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.reflect;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;
import net.dongliu.commons.Exceptions;
import net.dongliu.commons.exception.ReflectException;

public class InstanceMethod {
    private final Method method;
    private final MethodHandle methodHandle;

    public InstanceMethod(Method method) {
        Objects.requireNonNull(method);
        if (Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException("Method should not be static");
        }
        this.method = method;
        this.methodHandle = this.getHandle(method);
    }

    private MethodHandle getHandle(Method method) {
        method.setAccessible(true);
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            return lookup.unreflect(method);
        }
        catch (IllegalAccessException e) {
            throw new ReflectException(e);
        }
    }

    public String name() {
        return this.method.getName();
    }

    public MethodHandle methodHandle() {
        return this.methodHandle;
    }

    public Object call(Object instance, Object ... args) {
        if (this.method.getReturnType() == Void.TYPE) {
            this.run(instance, args);
            return null;
        }
        args = this.concat(Objects.requireNonNull(instance), args);
        try {
            return this.methodHandle.invokeWithArguments(args);
        }
        catch (Throwable throwable) {
            throw Exceptions.sneakyThrow(throwable);
        }
    }

    public void run(Object instance, Object ... args) {
        args = this.concat(Objects.requireNonNull(instance), args);
        try {
            this.methodHandle.invokeWithArguments(args);
        }
        catch (Throwable throwable) {
            throw Exceptions.sneakyThrow(throwable);
        }
    }

    private Object[] concat(Object instance, Object[] args) {
        if (args.length == 0) {
            return new Object[]{instance};
        }
        Object[] objects = new Object[args.length + 1];
        objects[0] = instance;
        System.arraycopy(args, 0, objects, 1, args.length);
        return objects;
    }

    public Object call(Object instance) {
        if (this.method.getReturnType() == Void.TYPE) {
            this.run(instance);
            return null;
        }
        try {
            return this.methodHandle.invoke(instance);
        }
        catch (Throwable throwable) {
            throw Exceptions.sneakyThrow(throwable);
        }
    }

    public void run(Object instance) {
        try {
            this.methodHandle.invoke(instance);
        }
        catch (Throwable throwable) {
            throw Exceptions.sneakyThrow(throwable);
        }
    }
}

