/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.reflect;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.dongliu.commons.exception.ReflectException;
import net.dongliu.commons.reflect.BeanProperty;
import net.dongliu.commons.reflect.ClassConstructor;
import net.dongliu.commons.reflect.InstanceField;
import net.dongliu.commons.reflect.InstanceMethod;
import net.dongliu.commons.reflect.StaticField;
import net.dongliu.commons.reflect.StaticMethod;

public class JavaClass<T> {
    private final Class<T> cls;
    private static final Object[] emptyArgs = new Object[0];

    private JavaClass(Class<T> cls) {
        this.cls = Objects.requireNonNull(cls);
    }

    @Nonnull
    public static <T> JavaClass<T> of(Class<T> cls) {
        return new JavaClass<T>(Objects.requireNonNull(cls));
    }

    @Nonnull
    public static <T> JavaClass<T> of(String className) {
        try {
            return new JavaClass(Class.forName(Objects.requireNonNull(className)));
        }
        catch (ClassNotFoundException e) {
            throw new ReflectException(e);
        }
    }

    @Nonnull
    public List<ClassConstructor<T>> getAllConstructors() {
        Constructor<?>[] constructors = this.cls.getDeclaredConstructors();
        ArrayList<ClassConstructor<T>> list = new ArrayList<ClassConstructor<T>>(constructors.length);
        for (Constructor<?> constructor : constructors) {
            list.add(new ClassConstructor(constructor));
        }
        return list;
    }

    @Nonnull
    public List<InstanceField> getAllFields() {
        Field[] declaredFields;
        ArrayList<InstanceField> fields = new ArrayList<InstanceField>(8);
        for (Field declaredField : declaredFields = this.cls.getDeclaredFields()) {
            if (Modifier.isStatic(declaredField.getModifiers())) continue;
            fields.add(new InstanceField(declaredField));
        }
        return fields;
    }

    @Nonnull
    public List<StaticField> getAllStaticFields() {
        Field[] declaredFields;
        ArrayList<StaticField> fields = new ArrayList<StaticField>(8);
        for (Field declaredField : declaredFields = this.cls.getDeclaredFields()) {
            if (!Modifier.isStatic(declaredField.getModifiers())) continue;
            fields.add(new StaticField(declaredField));
        }
        return fields;
    }

    @Nonnull
    public List<InstanceMethod> getAllMethods() {
        Method[] declaredMethods;
        ArrayList<InstanceMethod> methods = new ArrayList<InstanceMethod>();
        for (Method declaredMethod : declaredMethods = this.cls.getDeclaredMethods()) {
            if (Modifier.isStatic(declaredMethod.getModifiers())) continue;
            methods.add(new InstanceMethod(declaredMethod));
        }
        return methods;
    }

    @Nonnull
    public List<StaticMethod> getAllStaticMethods() {
        Method[] declaredMethods;
        ArrayList<StaticMethod> methods = new ArrayList<StaticMethod>();
        for (Method declaredMethod : declaredMethods = this.cls.getDeclaredMethods()) {
            if (!Modifier.isStatic(declaredMethod.getModifiers())) continue;
            methods.add(new StaticMethod(declaredMethod));
        }
        return methods;
    }

    @Nonnull
    public List<BeanProperty> getAllProperties() {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(this.cls);
        }
        catch (IntrospectionException e) {
            throw new ReflectException(e);
        }
        PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
        ArrayList<BeanProperty> list = new ArrayList<BeanProperty>(pds.length - 1);
        for (PropertyDescriptor pd : pds) {
            if (pd.getName().equals("class")) continue;
            list.add(new BeanProperty(pd));
        }
        return list;
    }

    @Nonnull
    public InstanceMethod getMethod(String name, Class<?> ... parameters) {
        Method method;
        try {
            method = this.cls.getDeclaredMethod(name, parameters);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectException(e);
        }
        return new InstanceMethod(method);
    }

    @Nonnull
    public StaticMethod getStaticMethod(String name, Class<?> ... parameters) {
        Method method;
        try {
            method = this.cls.getDeclaredMethod(name, parameters);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectException(e);
        }
        return new StaticMethod(method);
    }

    @Nonnull
    public ClassConstructor<T> getConstructor(Class<?> ... parameters) {
        Constructor<T> method;
        try {
            method = this.cls.getDeclaredConstructor(parameters);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectException(e);
        }
        return new ClassConstructor<T>(method);
    }

    @Nonnull
    public InstanceField getField(String name) {
        Field field;
        try {
            field = this.cls.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            throw new ReflectException(e);
        }
        return new InstanceField(field);
    }

    @Nonnull
    public BeanProperty getProperty(String name) {
        PropertyDescriptor[] pds;
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(this.cls);
        }
        catch (IntrospectionException e) {
            throw new ReflectException(e);
        }
        for (PropertyDescriptor pd : pds = beanInfo.getPropertyDescriptors()) {
            if (!pd.getName().equals(name)) continue;
            return new BeanProperty(pd);
        }
        throw new ReflectException(new IntrospectionException("property with name:" + name + " not found"));
    }

    @Nonnull
    public StaticField getStaticField(String name) {
        Field field;
        try {
            field = this.cls.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            throw new ReflectException(e);
        }
        return new StaticField(field);
    }

    public String className() {
        return this.cls.getSimpleName();
    }

    public String packageName() {
        return this.cls.getPackage().getName();
    }

    public String name() {
        return this.cls.getName();
    }

    public Class<T> getCls() {
        return this.cls;
    }
}

