/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.reflect;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Objects;
import javax.annotation.Nullable;
import net.dongliu.commons.Exceptions;
import net.dongliu.commons.exception.ReflectException;
import net.dongliu.commons.reflect.StandaloneProperty;

public class StaticField
implements StandaloneProperty {
    private final Field field;
    @Nullable
    private final MethodHandle getter;
    @Nullable
    private final MethodHandle setter;

    public StaticField(Field field) {
        Objects.requireNonNull(field);
        if (!Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException("Field should be static");
        }
        this.field = field;
        field.setAccessible(true);
        this.getter = this.getGetter(field);
        this.setter = this.getSetter(field);
    }

    private MethodHandle getGetter(Field field) {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            return lookup.unreflectGetter(field);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Nullable
    private MethodHandle getSetter(Field field) {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        if (!Modifier.isFinal(field.getModifiers())) {
            try {
                return lookup.unreflectSetter(field);
            }
            catch (IllegalAccessException e) {
                throw new ReflectException(e);
            }
        }
        return null;
    }

    @Override
    public String name() {
        return this.field.getName();
    }

    public MethodHandle getter() {
        return this.getter;
    }

    public MethodHandle setter() {
        if (this.setter == null) {
            throw new ReflectException(new IllegalAccessException("Filed can not write"));
        }
        return this.setter;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return !Modifier.isFinal(this.field.getModifiers());
    }

    @Override
    public Object get() {
        try {
            return this.getter().invoke();
        }
        catch (Throwable throwable) {
            throw Exceptions.sneakyThrow(throwable);
        }
    }

    @Override
    public void set(Object value) {
        try {
            this.setter().invoke(value);
        }
        catch (Throwable throwable) {
            throw Exceptions.sneakyThrow(throwable);
        }
    }

    @Override
    public byte getByte() {
        try {
            return this.getter().invokeExact();
        }
        catch (Throwable throwable) {
            throw Exceptions.sneakyThrow(throwable);
        }
    }

    @Override
    public void setByte(byte value) {
        try {
            this.setter().invokeExact(value);
        }
        catch (Throwable throwable) {
            throw Exceptions.sneakyThrow(throwable);
        }
    }

    @Override
    public short getShort() {
        try {
            return this.getter().invokeExact();
        }
        catch (Throwable throwable) {
            throw Exceptions.sneakyThrow(throwable);
        }
    }

    @Override
    public void setShort(short value) {
        try {
            this.setter().invokeExact(value);
        }
        catch (Throwable throwable) {
            throw Exceptions.sneakyThrow(throwable);
        }
    }

    @Override
    public int getInt() {
        try {
            return this.getter().invokeExact();
        }
        catch (Throwable throwable) {
            throw Exceptions.sneakyThrow(throwable);
        }
    }

    @Override
    public void setInt(int value) {
        try {
            this.setter().invokeExact(value);
        }
        catch (Throwable throwable) {
            throw Exceptions.sneakyThrow(throwable);
        }
    }

    @Override
    public long getLong() {
        try {
            return this.getter().invokeExact();
        }
        catch (Throwable throwable) {
            throw Exceptions.sneakyThrow(throwable);
        }
    }

    @Override
    public void setLong(long value) {
        try {
            this.setter().invokeExact(value);
        }
        catch (Throwable throwable) {
            throw Exceptions.sneakyThrow(throwable);
        }
    }

    @Override
    public double getDouble() {
        try {
            return this.getter().invokeExact();
        }
        catch (Throwable throwable) {
            throw Exceptions.sneakyThrow(throwable);
        }
    }

    @Override
    public void setDouble(double value) {
        try {
            this.setter().invokeExact(value);
        }
        catch (Throwable throwable) {
            throw Exceptions.sneakyThrow(throwable);
        }
    }

    @Override
    public float getFloat() {
        try {
            return this.getter().invokeExact();
        }
        catch (Throwable throwable) {
            throw Exceptions.sneakyThrow(throwable);
        }
    }

    @Override
    public void setFloat(float value) {
        try {
            this.setter().invokeExact(value);
        }
        catch (Throwable throwable) {
            throw Exceptions.sneakyThrow(throwable);
        }
    }

    @Override
    public boolean getBoolean() {
        try {
            return this.getter().invokeExact();
        }
        catch (Throwable throwable) {
            throw Exceptions.sneakyThrow(throwable);
        }
    }

    @Override
    public void setBoolean(boolean value) {
        try {
            this.setter().invokeExact(value);
        }
        catch (Throwable throwable) {
            throw Exceptions.sneakyThrow(throwable);
        }
    }

    @Override
    public char getChar() {
        try {
            return this.getter().invokeExact();
        }
        catch (Throwable throwable) {
            throw Exceptions.sneakyThrow(throwable);
        }
    }

    @Override
    public void setChar(char value) {
        try {
            this.setter().invokeExact(value);
        }
        catch (Throwable throwable) {
            throw Exceptions.sneakyThrow(throwable);
        }
    }
}

