/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.reflect;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;
import net.dongliu.commons.Exceptions;
import net.dongliu.commons.exception.ReflectException;

public class StaticMethod {
    private final Method method;
    private final MethodHandle methodHandle;

    public StaticMethod(Method method) {
        Objects.requireNonNull(method);
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException("Method should be static");
        }
        this.method = method;
        this.method.setAccessible(true);
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            this.methodHandle = lookup.unreflect(method);
        }
        catch (IllegalAccessException e) {
            throw new ReflectException(e);
        }
    }

    public String name() {
        return this.method.getName();
    }

    public MethodHandle methodHandle() {
        return this.methodHandle;
    }

    public Object call(Object ... args) {
        if (this.method.getReturnType() == Void.TYPE) {
            this.run(args);
            return null;
        }
        try {
            return this.methodHandle.invokeWithArguments(args);
        }
        catch (Throwable throwable) {
            throw Exceptions.sneakyThrow(throwable);
        }
    }

    public void run(Object ... args) {
        try {
            this.methodHandle.invokeWithArguments(args);
        }
        catch (Throwable throwable) {
            throw Exceptions.sneakyThrow(throwable);
        }
    }

    public Object call() {
        if (this.method.getReturnType() == Void.TYPE) {
            this.run();
            return null;
        }
        try {
            return this.methodHandle.invoke();
        }
        catch (Throwable throwable) {
            throw Exceptions.sneakyThrow(throwable);
        }
    }

    public void run() {
        try {
            this.methodHandle.invoke();
        }
        catch (Throwable throwable) {
            throw Exceptions.sneakyThrow(throwable);
        }
    }
}

