package net.dongliu.commons;

import java.util.function.Function;
import java.util.function.Supplier;

import static java.util.Objects.requireNonNull;

/**
 * Default Lazy impl.
 *
 * @param <T> the value type
 */
class LazyImpl<T> implements Lazy<T> {

    private boolean initialized;
    private Supplier<T> supplier;

    LazyImpl(Supplier<T> supplier) {
        this.supplier = () -> {
            synchronized (this) {
                if (!initialized) {
                    T value = supplier.get();
                    this.supplier = () -> value;
                    initialized = true;
                }
            }
            return this.supplier.get();
        };
    }

    @Override
    public T get() {
        return supplier.get();
    }

    @Override
    public <R> Lazy<R> map(Function<? super T, ? extends R> function) {
        return Lazy.of(() -> function.apply(get()));
    }
}
