package net.dongliu.commons.retry;

/**
 * A interface to get retry intervals.
 */
interface RetryBackOff {
    /**
     * return wait interval for nth retry
     *
     * @param retryTimes            the retry times
     * @param lastDelayMills        retry wait time for last retry
     * @param lastSecondDelayMillis retry wait time for second last retry
     */
    long nextIntervalOf(int retryTimes, long lastDelayMills, long lastSecondDelayMillis);
}
