package net.dongliu.commons.retry;

/**
 * Retry Listener. Implementations should not block or throw any exception.
 */
public interface RetryListener {

    /**
     * called when one retry begin
     * @param retryTimes start from 1
     */
    void onRetryBegin(int retryTimes);

    /**
     * called when one retry end
     * @param retryTimes start from 1
     */
    void onRetryEnd(int retryTimes);

    /**
     * called when retry exceed max times
     */
    void onMaxRetryTimesExceeded();
}
