/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons;

import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.DoubleFunction;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.LongFunction;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Stream;

public class Optionals {
    public static <T> Stream<T> stream(Optional<T> optional) {
        return optional.isPresent() ? Stream.of(optional.get()) : Stream.empty();
    }

    public static <T> Optional<T> or(Optional<T> optional1, Optional<T> optional2) {
        if (optional1.isPresent()) {
            return optional1;
        }
        return optional2;
    }

    @Deprecated
    public static <T> Optional<T> or(Optional<T> optional, Supplier<Optional<T>> supplier) {
        if (optional.isPresent()) {
            return optional;
        }
        return supplier.get();
    }

    public static <T> OptionalLong mapToLong(Optional<T> optional, ToLongFunction<? super T> function) {
        if (optional.isPresent()) {
            return OptionalLong.of(function.applyAsLong(optional.get()));
        }
        return OptionalLong.empty();
    }

    public static OptionalLong mapToLong(OptionalInt optional, IntToLongFunction function) {
        if (optional.isPresent()) {
            return OptionalLong.of(function.applyAsLong(optional.getAsInt()));
        }
        return OptionalLong.empty();
    }

    public static OptionalLong mapToLong(OptionalDouble optional, DoubleToLongFunction function) {
        if (optional.isPresent()) {
            return OptionalLong.of(function.applyAsLong(optional.getAsDouble()));
        }
        return OptionalLong.empty();
    }

    public static <T> OptionalInt mapToInt(Optional<T> optional, ToIntFunction<? super T> function) {
        if (optional.isPresent()) {
            return OptionalInt.of(function.applyAsInt(optional.get()));
        }
        return OptionalInt.empty();
    }

    public static OptionalInt mapToInt(OptionalLong optional, LongToIntFunction function) {
        if (optional.isPresent()) {
            return OptionalInt.of(function.applyAsInt(optional.getAsLong()));
        }
        return OptionalInt.empty();
    }

    public static OptionalInt mapToInt(OptionalDouble optional, DoubleToIntFunction function) {
        if (optional.isPresent()) {
            return OptionalInt.of(function.applyAsInt(optional.getAsDouble()));
        }
        return OptionalInt.empty();
    }

    public static <T> OptionalDouble mapToDouble(Optional<T> optional, ToDoubleFunction<? super T> function) {
        if (optional.isPresent()) {
            return OptionalDouble.of(function.applyAsDouble(optional.get()));
        }
        return OptionalDouble.empty();
    }

    public static OptionalDouble mapToInt(OptionalLong optional, LongToDoubleFunction function) {
        if (optional.isPresent()) {
            return OptionalDouble.of(function.applyAsDouble(optional.getAsLong()));
        }
        return OptionalDouble.empty();
    }

    public static OptionalDouble mapToInt(OptionalInt optional, IntToDoubleFunction function) {
        if (optional.isPresent()) {
            return OptionalDouble.of(function.applyAsDouble(optional.getAsInt()));
        }
        return OptionalDouble.empty();
    }

    public static <T> Optional<T> mapTo(OptionalLong optional, LongFunction<? extends T> function) {
        if (optional.isPresent()) {
            return Optional.of(function.apply(optional.getAsLong()));
        }
        return Optional.empty();
    }

    public static <T> Optional<T> mapTo(OptionalInt optional, IntFunction<? extends T> function) {
        if (optional.isPresent()) {
            return Optional.of(function.apply(optional.getAsInt()));
        }
        return Optional.empty();
    }

    public static <T> Optional<T> mapTo(OptionalDouble optional, DoubleFunction<? extends T> function) {
        if (optional.isPresent()) {
            return Optional.of(function.apply(optional.getAsDouble()));
        }
        return Optional.empty();
    }
}

