/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons;

import java.util.Objects;
import java.util.Random;

public abstract class Sampler {
    public static Sampler random(double rate) {
        return Sampler.random(new Random(), Sampler.checkRate(rate));
    }

    public static Sampler random(Random random, double rate) {
        Objects.requireNonNull(random);
        return new RandomSampler(random, Sampler.checkRate(rate));
    }

    public static Sampler roundRobin(double rate) {
        return new RoundRobinSampler(Sampler.checkRate(rate));
    }

    public void run(Runnable runnable) {
        if (this.shouldRun()) {
            runnable.run();
        }
    }

    public abstract boolean shouldRun();

    private static double checkRate(double rate) {
        if (rate < 0.0 || rate > 1.0) {
            throw new IllegalArgumentException("illegal rate value: " + rate);
        }
        return rate;
    }

    private static class RoundRobinSampler
    extends Sampler {
        private final double rate;
        private double current;

        private RoundRobinSampler(Double rate) {
            this.rate = rate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean shouldRun() {
            if (this.rate <= 0.0) {
                return false;
            }
            if (this.rate >= 1.0) {
                return true;
            }
            RoundRobinSampler roundRobinSampler = this;
            synchronized (roundRobinSampler) {
                this.current += this.rate;
                if (this.current > 1.0) {
                    this.current -= 1.0;
                    return true;
                }
            }
            return false;
        }
    }

    private static class RandomSampler
    extends Sampler {
        private final Random random;
        private final Double rate;

        private RandomSampler(Random random, Double rate) {
            this.random = random;
            this.rate = rate;
        }

        @Override
        public boolean shouldRun() {
            double v = this.random.nextDouble();
            return v < this.rate;
        }
    }
}

