/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons;

import java.util.Arrays;
import java.util.Objects;
import net.dongliu.commons.Joiner;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Strings {
    public static String nullToEmpty(@Nullable String str) {
        return str == null ? "" : str;
    }

    public static int toInt(String str, int defaultValue) {
        try {
            return Integer.parseInt(str);
        }
        catch (NullPointerException | NumberFormatException e) {
            return defaultValue;
        }
    }

    public static long toLong(String str, long defaultValue) {
        try {
            return Long.parseLong(str);
        }
        catch (NullPointerException | NumberFormatException e) {
            return defaultValue;
        }
    }

    public static float toFloat(String str, float defaultValue) {
        try {
            return Float.parseFloat(str);
        }
        catch (NullPointerException | NumberFormatException e) {
            return defaultValue;
        }
    }

    public static double toDouble(String str, double defaultValue) {
        try {
            return Double.parseDouble(str);
        }
        catch (NullPointerException | NumberFormatException e) {
            return defaultValue;
        }
    }

    @Deprecated
    public static String join(CharSequence prefix, CharSequence suffix, CharSequence delimiter, Iterable<? extends CharSequence> strings) {
        Objects.requireNonNull(prefix);
        Objects.requireNonNull(suffix);
        Objects.requireNonNull(delimiter);
        Objects.requireNonNull(strings);
        return Joiner.of(prefix, suffix, delimiter).join(strings);
    }

    @Deprecated
    public static String join(CharSequence prefix, CharSequence suffix, CharSequence delimiter, CharSequence ... strings) {
        Objects.requireNonNull(prefix);
        Objects.requireNonNull(suffix);
        Objects.requireNonNull(delimiter);
        Objects.requireNonNull(strings);
        return Joiner.of(prefix, suffix, delimiter).join(strings);
    }

    public static String repeat(String str, int times) {
        Objects.requireNonNull(str);
        if (times < 0) {
            throw new IllegalArgumentException("repeat count less then zero");
        }
        if (str.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(str.length() * times);
        for (int i = 0; i < times; ++i) {
            sb.append(str);
        }
        return sb.toString();
    }

    public static String subStringBefore(String str, String sep) {
        Objects.requireNonNull(str);
        Objects.requireNonNull(sep);
        if (sep.isEmpty()) {
            throw new IllegalArgumentException("separator cannot be empty");
        }
        int index = str.indexOf(sep);
        if (index < 0) {
            return str;
        }
        return str.substring(0, index);
    }

    public static String subStringBeforeLast(String str, String sep) {
        Objects.requireNonNull(str);
        Objects.requireNonNull(sep);
        if (sep.isEmpty()) {
            throw new IllegalArgumentException("separator cannot be empty");
        }
        int index = str.lastIndexOf(sep);
        if (index < 0) {
            return str;
        }
        return str.substring(0, index);
    }

    public static String subStringAfter(String str, String sep) {
        Objects.requireNonNull(str);
        Objects.requireNonNull(sep);
        if (sep.isEmpty()) {
            throw new IllegalArgumentException("separator cannot be empty");
        }
        int index = str.indexOf(sep);
        if (index < 0) {
            return str;
        }
        return str.substring(index + sep.length());
    }

    public static String subStringAfterLast(String str, String sep) {
        Objects.requireNonNull(str);
        Objects.requireNonNull(sep);
        if (sep.isEmpty()) {
            throw new IllegalArgumentException("separator cannot be empty");
        }
        int index = str.lastIndexOf(sep);
        if (index < 0) {
            return str;
        }
        return str.substring(index + sep.length());
    }

    public static int countOf(String str, String sub) {
        return Strings.countOf(str, sub, false);
    }

    public static int countOf(String str, String sub, boolean overlap) {
        int index;
        Objects.requireNonNull(str);
        Objects.requireNonNull(sub);
        if (sub.isEmpty()) {
            throw new IllegalArgumentException("sub string cannot be empty");
        }
        int count = 0;
        int offset = 0;
        while ((index = str.indexOf(sub, offset)) != -1) {
            offset = overlap ? index + 1 : index + sub.length();
            ++count;
        }
        return count;
    }

    @Deprecated
    public static String trimSuffix(String str, String suffix) {
        return Strings.removeSuffix(str, suffix);
    }

    @Deprecated
    public static String trimPrefix(String str, String prefix) {
        return Strings.removePrefix(str, prefix);
    }

    public static String removeSuffix(String str, String suffix) {
        Objects.requireNonNull(str);
        Objects.requireNonNull(suffix);
        if (str.endsWith(suffix)) {
            return str.substring(0, str.length() - suffix.length());
        }
        return str;
    }

    public static String removePrefix(String str, String prefix) {
        Objects.requireNonNull(str);
        Objects.requireNonNull(prefix);
        if (str.startsWith(prefix)) {
            return str.substring(prefix.length());
        }
        return str;
    }

    public static String removePrefixAndSuffix(String str, String prefix, String suffix) {
        Objects.requireNonNull(str);
        Objects.requireNonNull(prefix);
        Objects.requireNonNull(suffix);
        if (str.isEmpty()) {
            return str;
        }
        int start = 0;
        if (str.startsWith(prefix)) {
            start = prefix.length();
        }
        int end = str.length();
        if (str.endsWith(suffix)) {
            end = str.length() - suffix.length();
        }
        if (start >= end) {
            return "";
        }
        return str.substring(start, end);
    }

    public static String removePrefix(String str, int len) {
        Objects.requireNonNull(str);
        if (len < 0) {
            throw new IllegalArgumentException("invalid len: " + len);
        }
        if (len >= str.length()) {
            return "";
        }
        return str.substring(len);
    }

    public static String removeSuffix(String str, int len) {
        Objects.requireNonNull(str);
        if (len < 0) {
            throw new IllegalArgumentException("invalid len: " + len);
        }
        if (len >= str.length()) {
            return "";
        }
        return str.substring(0, str.length() - len);
    }

    public static String capitalize(String str) {
        Objects.requireNonNull(str);
        if (str.isEmpty()) {
            return str;
        }
        char c = str.charAt(0);
        if (Character.isUpperCase(c)) {
            return str;
        }
        return Character.toUpperCase(c) + str.substring(1);
    }

    public static String deCapitalize(String str) {
        Objects.requireNonNull(str);
        if (str.isEmpty()) {
            return str;
        }
        char c = str.charAt(0);
        if (Character.isLowerCase(c)) {
            return str;
        }
        return Character.toLowerCase(c) + str.substring(1);
    }

    public static String padLeft(String str, int len, char padding) {
        Objects.requireNonNull(str);
        if (str.length() >= len) {
            return str;
        }
        char[] chars = new char[len];
        Arrays.fill(chars, 0, len - str.length(), padding);
        str.getChars(0, str.length(), chars, len - str.length());
        return new String(chars);
    }

    public static String padRight(String str, int len, char padding) {
        Objects.requireNonNull(str);
        if (str.length() >= len) {
            return str;
        }
        char[] chars = new char[len];
        str.getChars(0, str.length(), chars, 0);
        Arrays.fill(chars, str.length(), len, padding);
        return new String(chars);
    }

    public static String padToCenter(String str, int len, char padding) {
        Objects.requireNonNull(str);
        if (str.length() >= len) {
            return str;
        }
        int toBePad = len - str.length();
        int left = toBePad / 2;
        int right = toBePad - left;
        char[] chars = new char[len];
        Arrays.fill(chars, 0, left, padding);
        str.getChars(0, str.length(), chars, left);
        Arrays.fill(chars, len - right, len, padding);
        return new String(chars);
    }

    public static String joinLines(Iterable<? extends CharSequence> strings) {
        StringBuilder sb = new StringBuilder();
        for (CharSequence charSequence : strings) {
            sb.append(charSequence).append("\n");
        }
        return sb.toString();
    }

    public static String prependIfMissing(String str, String prefix) {
        Objects.requireNonNull(str);
        Objects.requireNonNull(prefix);
        if (str.isEmpty()) {
            return prefix;
        }
        if (!str.startsWith(prefix)) {
            return prefix + str;
        }
        return str;
    }

    public static String appendIfMissing(String str, String suffix) {
        Objects.requireNonNull(str);
        Objects.requireNonNull(suffix);
        if (str.isEmpty()) {
            return suffix;
        }
        if (!str.endsWith(suffix)) {
            return str + suffix;
        }
        return str;
    }

    public static String reverse(String str) {
        Objects.requireNonNull(str);
        if (str.length() <= 1) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str.length());
        for (int i = str.length() - 1; i >= 0; --i) {
            sb.append(str.charAt(i));
        }
        return sb.toString();
    }
}

