/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.concurrent;

import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.dongliu.commons.concurrent.ThreadFactories;
import net.dongliu.commons.concurrent.ThreadPoolBuilder;

public class Executors2 {
    public static ExecutorService newFixedThreadPool(int poolSize, int queueSize, String threadNamePrefix) {
        return Executors2.newFixedThreadPool(poolSize, queueSize, ThreadFactories.newDaemonThreadFactory(threadNamePrefix));
    }

    public static ExecutorService newFixedThreadPool(int poolSize, int queueSize, ThreadFactory threadFactory) {
        return Executors2.newFixedThreadPool(poolSize, queueSize, threadFactory, new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public static ExecutorService newFixedThreadPool(int poolSize, int queueSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        return new ThreadPoolBuilder().poolSize(poolSize, poolSize).workingQueue(new ArrayBlockingQueue<Runnable>(queueSize)).threadFactory(threadFactory).rejectedHandler(handler).build();
    }

    public static ThreadPoolBuilder threadPoolBuilder() {
        return new ThreadPoolBuilder();
    }

    public static void shutdownAndAwait(ExecutorService executor, Duration timeout) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(timeout);
        executor.shutdown();
        try {
            if (!executor.awaitTermination(timeout.toNanos(), TimeUnit.NANOSECONDS)) {
                executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public static ScheduledFuture<?> scheduleAt(ScheduledExecutorService executor, Runnable runnable, Instant instant) {
        Instant now = Instant.now();
        long nanos = (instant.getEpochSecond() - now.getEpochSecond()) * 1000000000L + (long)(instant.getNano() - now.getNano());
        if (nanos < 0L) {
            nanos = 0L;
        }
        return executor.schedule(runnable, nanos, TimeUnit.NANOSECONDS);
    }

    public static <T> ScheduledFuture<T> scheduleAt(ScheduledExecutorService executor, Callable<T> callable, Instant instant) {
        Instant now = Instant.now();
        long nanos = (instant.getEpochSecond() - now.getEpochSecond()) * 1000000000L + (long)(instant.getNano() - now.getNano());
        if (nanos < 0L) {
            nanos = 0L;
        }
        return executor.schedule(callable, nanos, TimeUnit.NANOSECONDS);
    }
}

