/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import net.dongliu.commons.Throwables;
import net.dongliu.commons.collection.Lists;

public class TeeOutputStream
extends OutputStream {
    private final List<OutputStream> outputs;

    public TeeOutputStream(OutputStream ... outputs) {
        this(Lists.of(outputs));
    }

    public TeeOutputStream(List<OutputStream> outputs) {
        this.outputs = outputs;
    }

    @Override
    public void write(byte[] b) throws IOException {
        for (OutputStream output : this.outputs) {
            output.write(b);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        for (OutputStream output : this.outputs) {
            output.write(b, off, len);
        }
    }

    @Override
    public void flush() throws IOException {
        for (OutputStream output : this.outputs) {
            output.flush();
        }
    }

    @Override
    public void close() throws IOException {
        Throwable t = null;
        for (OutputStream output : this.outputs) {
            try {
                output.close();
            }
            catch (Throwable e) {
                if (t == null) {
                    t = e;
                    continue;
                }
                t.addSuppressed(e);
            }
        }
        if (t != null) {
            throw Throwables.sneakyThrow(t);
        }
    }

    @Override
    public void write(int b) throws IOException {
        for (OutputStream output : this.outputs) {
            output.write(b);
        }
    }
}

