/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.sequence;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.dongliu.commons.sequence.CollectConsumer;

public class SeqCollectors {
    private SeqCollectors() {
    }

    public static <T extends Comparable<T>> CollectConsumer<T, Optional<T>> max() {
        return new CollectConsumer<T, Optional<T>>(){
            private T value;

            @Override
            public void accept(T value) {
                Objects.requireNonNull(value);
                if (this.value == null || this.value.compareTo(value) < 0) {
                    this.value = value;
                }
            }

            @Override
            public Optional<T> finish() {
                return Optional.ofNullable(this.value);
            }
        };
    }

    public static <T extends Comparable<T>> CollectConsumer<T, Optional<T>> min() {
        return new CollectConsumer<T, Optional<T>>(){
            private T value;

            @Override
            public void accept(T value) {
                Objects.requireNonNull(value);
                if (this.value == null || this.value.compareTo(value) > 0) {
                    this.value = value;
                }
            }

            @Override
            public Optional<T> finish() {
                return Optional.ofNullable(this.value);
            }
        };
    }

    public static <K, V> CollectConsumer<Map.Entry<K, V>, Map<K, V>> toMap(final Supplier<Map<K, V>> mapSupplier) {
        Objects.requireNonNull(mapSupplier);
        return new CollectConsumer<Map.Entry<K, V>, Map<K, V>>(){
            private Map<K, V> map;
            {
                this.map = (Map)mapSupplier.get();
            }

            @Override
            public void accept(Map.Entry<K, V> entry) {
                this.map.put(entry.getKey(), entry.getValue());
            }

            @Override
            public Map<K, V> finish() {
                return this.map;
            }
        };
    }

    public static <K, V> CollectConsumer<Map.Entry<K, V>, Map<K, V>> toHashMap() {
        return SeqCollectors.toMap(HashMap::new);
    }

    public static <K, V> CollectConsumer<Map.Entry<K, V>, Map<K, V>> toImmutableMap() {
        return new CollectConsumer<Map.Entry<K, V>, Map<K, V>>(){
            private Map<K, V> map = new HashMap();

            @Override
            public void accept(Map.Entry<K, V> entry) {
                this.map.put(entry.getKey(), entry.getValue());
            }

            @Override
            public Map<K, V> finish() {
                return Collections.unmodifiableMap(this.map);
            }
        };
    }
}

