/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests;

import java.io.InputStream;
import net.dongliu.requests.BodyRequestBuilderInterface;
import net.dongliu.requests.RequestBuilder;
import net.dongliu.requests.exception.DuplicateBodyException;
import net.dongliu.requests.struct.BytesHttpBody;
import net.dongliu.requests.struct.HttpBody;
import net.dongliu.requests.struct.InputHttpBody;
import net.dongliu.requests.struct.StringHttpBody;

public abstract class AbstractBodyRequestBuilder<T extends AbstractBodyRequestBuilder<T>>
extends RequestBuilder<T>
implements BodyRequestBuilderInterface<T> {
    protected HttpBody httpBody;

    protected AbstractBodyRequestBuilder() {
    }

    @Override
    public T data(byte[] data) {
        this.checkHttpBody(BytesHttpBody.class);
        this.httpBody = new BytesHttpBody(data);
        return (T)((AbstractBodyRequestBuilder)this.self());
    }

    @Override
    public T data(InputStream in) {
        this.checkHttpBody(InputHttpBody.class);
        this.httpBody = new InputHttpBody(in);
        return (T)((AbstractBodyRequestBuilder)this.self());
    }

    @Override
    public T data(String body) {
        this.checkHttpBody(StringHttpBody.class);
        this.httpBody = new StringHttpBody(body);
        return (T)((AbstractBodyRequestBuilder)this.self());
    }

    protected <R extends HttpBody> void checkHttpBody(Class<R> cls) {
        if (this.httpBody != null && !cls.isAssignableFrom(this.httpBody.getClass())) {
            throw new DuplicateBodyException(this.httpBody.getClass());
        }
    }
}

