/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.dongliu.requests.BodyRequestBuilder;
import net.dongliu.requests.HeadOnlyRequestBuilder;
import net.dongliu.requests.PooledClientBuilder;
import net.dongliu.requests.PostRequestBuilder;
import net.dongliu.requests.Request;
import net.dongliu.requests.Response;
import net.dongliu.requests.ResponseProcessor;
import net.dongliu.requests.Session;
import net.dongliu.requests.SingleClientBuilder;
import net.dongliu.requests.encode.URIBuilder;
import net.dongliu.requests.exception.RequestException;
import net.dongliu.requests.struct.BytesHttpBody;
import net.dongliu.requests.struct.Cookie;
import net.dongliu.requests.struct.Cookies;
import net.dongliu.requests.struct.FormHttpBody;
import net.dongliu.requests.struct.Header;
import net.dongliu.requests.struct.Headers;
import net.dongliu.requests.struct.HttpBody;
import net.dongliu.requests.struct.InputHttpBody;
import net.dongliu.requests.struct.Method;
import net.dongliu.requests.struct.MultiPart;
import net.dongliu.requests.struct.MultiPartHttpBody;
import net.dongliu.requests.struct.Parameter;
import net.dongliu.requests.struct.StringHttpBody;
import org.apache.http.HttpEntity;
import org.apache.http.client.CookieStore;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BasicNameValuePair;

public class Client
implements Closeable {
    private final CloseableHttpClient client;
    private final boolean closeOnRequestFinished;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public Client(CloseableHttpClient client, boolean closeOnRequestFinished) {
        this.client = client;
        this.closeOnRequestFinished = closeOnRequestFinished;
    }

    public static PooledClientBuilder pooled() {
        return new PooledClientBuilder();
    }

    public static SingleClientBuilder single() {
        return new SingleClientBuilder();
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.client.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    boolean getClosed() {
        return this.closed.get();
    }

    public HeadOnlyRequestBuilder get(String url) throws RequestException {
        return (HeadOnlyRequestBuilder)((HeadOnlyRequestBuilder)((HeadOnlyRequestBuilder)new HeadOnlyRequestBuilder().client(this)).method(Method.GET)).url(url);
    }

    public HeadOnlyRequestBuilder head(String url) throws RequestException {
        return (HeadOnlyRequestBuilder)((HeadOnlyRequestBuilder)((HeadOnlyRequestBuilder)new HeadOnlyRequestBuilder().client(this)).method(Method.HEAD)).url(url);
    }

    public PostRequestBuilder post(String url) throws RequestException {
        return (PostRequestBuilder)((PostRequestBuilder)((PostRequestBuilder)new PostRequestBuilder().client(this)).method(Method.POST)).url(url);
    }

    public BodyRequestBuilder put(String url) throws RequestException {
        return (BodyRequestBuilder)((BodyRequestBuilder)((BodyRequestBuilder)new BodyRequestBuilder().client(this)).method(Method.PUT)).url(url);
    }

    public HeadOnlyRequestBuilder delete(String url) throws RequestException {
        return (HeadOnlyRequestBuilder)((HeadOnlyRequestBuilder)((HeadOnlyRequestBuilder)new HeadOnlyRequestBuilder().client(this)).method(Method.DELETE)).url(url);
    }

    public HeadOnlyRequestBuilder options(String url) throws RequestException {
        return (HeadOnlyRequestBuilder)((HeadOnlyRequestBuilder)((HeadOnlyRequestBuilder)new HeadOnlyRequestBuilder().client(this)).method(Method.OPTIONS)).url(url);
    }

    public BodyRequestBuilder patch(String url) throws RequestException {
        return (BodyRequestBuilder)((BodyRequestBuilder)((BodyRequestBuilder)new BodyRequestBuilder().client(this)).method(Method.PATCH)).url(url);
    }

    public HeadOnlyRequestBuilder trace(String url) throws RequestException {
        return (HeadOnlyRequestBuilder)((HeadOnlyRequestBuilder)((HeadOnlyRequestBuilder)new HeadOnlyRequestBuilder().client(this)).method(Method.TRACE)).url(url);
    }

    public Session session() {
        return new Session(this);
    }

    CloseableHttpClient getHttpClient() {
        return this.client;
    }

    /*
     * Exception decompiling
     */
    <T> Response<T> execute(Request request, ResponseProcessor<T> processor, Session session) throws RequestException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private HttpRequestBase buildRequest(Request request, HttpClientContext context) {
        HttpPost httpRequest;
        URI uri = this.joinFullUrl(request.getUrl(), request.getCharset(), request.getParameters());
        switch (request.getMethod()) {
            case POST: {
                httpRequest = this.buildHttpPost(uri, request);
                break;
            }
            case GET: {
                httpRequest = new HttpGet(uri);
                break;
            }
            case HEAD: {
                httpRequest = new HttpHead(uri);
                break;
            }
            case PUT: {
                httpRequest = this.buildHttpPut(uri, request);
                break;
            }
            case DELETE: {
                httpRequest = new HttpDelete(uri);
                break;
            }
            case OPTIONS: {
                httpRequest = new HttpOptions(uri);
                break;
            }
            case TRACE: {
                httpRequest = new HttpTrace(uri);
                break;
            }
            case PATCH: {
                httpRequest = this.buildHttpPatch(uri, request);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported method:" + (Object)((Object)request.getMethod()));
            }
        }
        CookieStore cookieStore = context.getCookieStore();
        if (request.getCookies() != null) {
            for (Cookie cookie : request.getCookies()) {
                BasicClientCookie clientCookie = new BasicClientCookie((String)cookie.getName(), (String)cookie.getValue());
                clientCookie.setDomain(request.getUrl().getHost());
                clientCookie.setPath("/");
                cookieStore.addCookie((org.apache.http.cookie.Cookie)clientCookie);
            }
        }
        if (request.getHeaders() != null) {
            for (Header header : request.getHeaders()) {
                httpRequest.setHeader((String)header.getName(), (String)header.getValue());
            }
        }
        return httpRequest;
    }

    private HttpRequestBase buildHttpPut(URI uri, Request request) {
        HttpPut httpPut = new HttpPut(uri);
        HttpBody body = request.getHttpBody();
        if (request.getHttpBody() != null) {
            if (body instanceof StringHttpBody) {
                httpPut.setEntity((HttpEntity)new StringEntity((String)((StringHttpBody)body).getBody(), request.getCharset()));
            } else if (body instanceof BytesHttpBody) {
                httpPut.setEntity((HttpEntity)new ByteArrayEntity((byte[])((BytesHttpBody)body).getBody()));
            } else if (body instanceof InputHttpBody) {
                httpPut.setEntity((HttpEntity)new InputStreamEntity((InputStream)((InputHttpBody)body).getBody()));
            }
        }
        return httpPut;
    }

    private HttpPost buildHttpPost(URI uri, Request request) {
        HttpPost httpPost = new HttpPost(uri);
        HttpBody body = request.getHttpBody();
        if (body instanceof MultiPartHttpBody) {
            MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
            for (MultiPart f : (List)((MultiPartHttpBody)body).getBody()) {
                switch (f.getType()) {
                    case TEXT: {
                        entityBuilder.addTextBody(f.getName(), f.getValue());
                        break;
                    }
                    case FILE: {
                        entityBuilder.addBinaryBody(f.getName(), f.getFile(), ContentType.create((String)f.getMime()), f.getFileName());
                        break;
                    }
                    case STREAM: {
                        entityBuilder.addBinaryBody(f.getName(), f.getIn(), ContentType.create((String)f.getMime()), f.getFileName());
                        break;
                    }
                    case BYTES: {
                        entityBuilder.addBinaryBody(f.getName(), f.getBytes(), ContentType.create((String)f.getMime()), f.getFileName());
                    }
                }
            }
            httpPost.setEntity(entityBuilder.build());
        } else if (body instanceof StringHttpBody) {
            httpPost.setEntity((HttpEntity)new StringEntity((String)((StringHttpBody)body).getBody(), request.getCharset()));
        } else if (body instanceof BytesHttpBody) {
            httpPost.setEntity((HttpEntity)new ByteArrayEntity((byte[])((BytesHttpBody)body).getBody()));
        } else if (body instanceof InputHttpBody) {
            httpPost.setEntity((HttpEntity)new InputStreamEntity((InputStream)((InputHttpBody)body).getBody()));
        } else if (body instanceof FormHttpBody) {
            List forms = (List)((FormHttpBody)body).getBody();
            ArrayList<BasicNameValuePair> paramList = new ArrayList<BasicNameValuePair>(forms.size());
            for (Parameter param : forms) {
                paramList.add(new BasicNameValuePair((String)param.getName(), (String)param.getValue()));
            }
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(paramList, request.getCharset());
            httpPost.setEntity((HttpEntity)entity);
        }
        return httpPost;
    }

    private HttpRequestBase buildHttpPatch(URI uri, Request request) {
        HttpPatch httpPatch = new HttpPatch(uri);
        HttpBody body = request.getHttpBody();
        if (request.getHttpBody() != null) {
            if (body instanceof StringHttpBody) {
                httpPatch.setEntity((HttpEntity)new StringEntity((String)((StringHttpBody)body).getBody(), request.getCharset()));
            } else if (body instanceof BytesHttpBody) {
                httpPatch.setEntity((HttpEntity)new ByteArrayEntity((byte[])((BytesHttpBody)body).getBody()));
            } else if (body instanceof InputHttpBody) {
                httpPatch.setEntity((HttpEntity)new InputStreamEntity((InputStream)((InputHttpBody)body).getBody()));
            }
        }
        return httpPatch;
    }

    private URI joinFullUrl(URI url, Charset charset, List<Parameter> parameters) {
        try {
            if (parameters == null || parameters.isEmpty()) {
                return url;
            }
            URIBuilder urlBuilder = new URIBuilder(url).setCharset(charset);
            for (Parameter param : parameters) {
                urlBuilder.addParameter((String)param.getName(), (String)param.getValue());
            }
            return urlBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new RequestException(e);
        }
    }

    private <T> Response<T> wrapResponse(CloseableHttpResponse httpResponse, HttpClientContext context, ResponseProcessor<T> processor) throws IOException {
        Response<T> response = new Response<T>();
        response.setStatusCode(httpResponse.getStatusLine().getStatusCode());
        org.apache.http.Header[] respHeaders = httpResponse.getAllHeaders();
        Headers headers = new Headers();
        for (org.apache.http.Header header : respHeaders) {
            headers.add(new Header(header.getName(), header.getValue()));
        }
        response.setHeaders(headers);
        Cookies cookies = new Cookies();
        for (org.apache.http.cookie.Cookie c : context.getCookieStore().getCookies()) {
            Cookie cookie = new Cookie(c.getName(), c.getValue());
            cookie.setPath(c.getPath());
            cookie.setDomain(c.getDomain());
            cookie.setPath(c.getPath());
            cookie.setExpiry(c.getExpiryDate());
            cookies.add(cookie);
        }
        response.setCookies(cookies);
        response.setHistory(context.getRedirectLocations());
        HttpEntity entity = httpResponse.getEntity();
        T result = processor.convert(response.getStatusCode(), headers, entity);
        response.setBody(result);
        return response;
    }
}

