/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.dongliu.requests.AbstractBodyRequestBuilder;
import net.dongliu.requests.PostRequestBuilderInterface;
import net.dongliu.requests.Request;
import net.dongliu.requests.struct.FormHttpBody;
import net.dongliu.requests.struct.MultiPart;
import net.dongliu.requests.struct.MultiPartHttpBody;
import net.dongliu.requests.struct.Parameter;

public class PostRequestBuilder
extends AbstractBodyRequestBuilder<PostRequestBuilder>
implements PostRequestBuilderInterface<PostRequestBuilder> {
    protected PostRequestBuilder() {
    }

    @Override
    public Request build() {
        return new Request(this.method, this.url, this.parameters, this.headers, this.httpBody, this.charset, this.authInfo, this.cookies);
    }

    @Override
    protected PostRequestBuilder self() {
        return this;
    }

    @Override
    public PostRequestBuilder addForm(String key, Object value) {
        List<Parameter> params = this.ensureFormParameters();
        params.add(Parameter.of(key, value));
        return this;
    }

    @Override
    public PostRequestBuilder forms(Map<String, ?> map) {
        this.checkHttpBody(FormHttpBody.class);
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        for (Map.Entry<String, ?> e : map.entrySet()) {
            params.add(Parameter.of(e.getKey(), e.getValue()));
        }
        this.httpBody = new FormHttpBody((List<Parameter>)params);
        return this;
    }

    @Override
    public PostRequestBuilder forms(Parameter ... parameters) {
        this.checkHttpBody(FormHttpBody.class);
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        Collections.addAll(params, parameters);
        this.httpBody = new FormHttpBody((List<Parameter>)params);
        return this;
    }

    @Override
    public PostRequestBuilder forms(Collection<Parameter> parameters) {
        this.checkHttpBody(FormHttpBody.class);
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        params.addAll(parameters);
        this.httpBody = new FormHttpBody((List<Parameter>)params);
        return this;
    }

    private List<Parameter> ensureFormParameters() {
        this.checkHttpBody(FormHttpBody.class);
        if (this.httpBody == null) {
            this.httpBody = new FormHttpBody((List<Parameter>)new ArrayList<Parameter>());
        }
        return (List)((FormHttpBody)this.httpBody).getBody();
    }

    @Override
    public PostRequestBuilder addMultiPart(File file) {
        List<MultiPart> mps = this.ensureMultiPart();
        mps.add(new MultiPart(file.getName(), file));
        return this;
    }

    @Override
    public PostRequestBuilder addMultiPart(String name, File file) {
        List<MultiPart> mps = this.ensureMultiPart();
        mps.add(new MultiPart(name, file));
        return this;
    }

    @Override
    public PostRequestBuilder addMultiPart(String name, String mimeType, File file) {
        List<MultiPart> mps = this.ensureMultiPart();
        mps.add(new MultiPart(name, mimeType, file));
        return this;
    }

    @Override
    public PostRequestBuilder addMultiPart(String name, String mimeType, byte[] bytes) {
        this.addMultiPart(name, mimeType, null, bytes);
        return this;
    }

    @Override
    public PostRequestBuilder addMultiPart(String name, String mimeType, String fileName, byte[] bytes) {
        List<MultiPart> mps = this.ensureMultiPart();
        mps.add(new MultiPart(name, mimeType, fileName, bytes));
        return this;
    }

    @Override
    public PostRequestBuilder addMultiPart(String name, String mimeType, InputStream in) {
        this.addMultiPart(name, mimeType, null, in);
        return this;
    }

    @Override
    public PostRequestBuilder addMultiPart(String name, String mimeType, String fileName, InputStream in) {
        List<MultiPart> mps = this.ensureMultiPart();
        mps.add(new MultiPart(name, mimeType, fileName, in));
        return this;
    }

    @Override
    public PostRequestBuilder addMultiPart(String name, String value) {
        List<MultiPart> mps = this.ensureMultiPart();
        mps.add(new MultiPart(name, value));
        return this;
    }

    private List<MultiPart> ensureMultiPart() {
        this.checkHttpBody(MultiPartHttpBody.class);
        if (this.httpBody == null) {
            this.httpBody = new MultiPartHttpBody((List<MultiPart>)new ArrayList<MultiPart>());
        }
        return (List)((MultiPartHttpBody)this.httpBody).getBody();
    }
}

