/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.dongliu.requests.BaseRequestBuilderInterface;
import net.dongliu.requests.Client;
import net.dongliu.requests.Executable;
import net.dongliu.requests.FileResponseProcessor;
import net.dongliu.requests.Request;
import net.dongliu.requests.Response;
import net.dongliu.requests.ResponseHandler;
import net.dongliu.requests.ResponseHandlerAdapter;
import net.dongliu.requests.ResponseProcessor;
import net.dongliu.requests.Session;
import net.dongliu.requests.StringResponseProcessor;
import net.dongliu.requests.exception.RequestException;
import net.dongliu.requests.struct.AuthInfo;
import net.dongliu.requests.struct.Cookie;
import net.dongliu.requests.struct.Header;
import net.dongliu.requests.struct.Method;
import net.dongliu.requests.struct.Parameter;

public abstract class RequestBuilder<T extends RequestBuilder<T>>
implements Executable,
BaseRequestBuilderInterface<T> {
    private Client client;
    protected Method method;
    protected URI url;
    protected List<Parameter> parameters;
    protected List<Header> headers;
    protected List<Cookie> cookies;
    protected Charset charset = StandardCharsets.UTF_8;
    protected AuthInfo authInfo;
    protected Session session;

    <R> Response<R> execute(ResponseProcessor<R> processor) throws RequestException {
        Request request = this.build();
        return this.client.execute(request, processor, this.session);
    }

    @Override
    public <R> Response<R> handle(ResponseHandler<R> handler) throws RequestException {
        return this.execute(new ResponseHandlerAdapter<R>(handler));
    }

    @Override
    public Response<String> text(Charset responseCharset) throws RequestException {
        return this.execute(new StringResponseProcessor(responseCharset));
    }

    @Override
    public Response<String> text() throws RequestException {
        return this.execute(new StringResponseProcessor(null));
    }

    @Override
    public Response<byte[]> bytes() throws RequestException {
        return this.execute(ResponseProcessor.bytes);
    }

    @Override
    public Response<File> file(File file) throws RequestException {
        return this.execute(new FileResponseProcessor(file));
    }

    @Override
    public Response<File> file(String filePath) throws RequestException {
        return this.execute(new FileResponseProcessor(filePath));
    }

    T client(Client client) {
        this.client = client;
        return this.self();
    }

    T url(String url) throws RequestException {
        try {
            this.url = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new RequestException(e);
        }
        return this.self();
    }

    public abstract Request build();

    @Override
    public T params(Map<String, ?> params) {
        this.parameters = new ArrayList<Parameter>(params.size());
        for (Map.Entry<String, ?> entry : params.entrySet()) {
            this.parameters.add(Parameter.of(entry.getKey(), entry.getValue()));
        }
        return this.self();
    }

    @Override
    public T params(Parameter ... params) {
        this.parameters = new ArrayList<Parameter>(params.length);
        for (Parameter param : params) {
            this.parameters.add(new Parameter((String)param.getName(), (String)param.getValue()));
        }
        return this.self();
    }

    @Override
    public T params(Collection<Parameter> params) {
        this.parameters = new ArrayList<Parameter>(params.size());
        for (Parameter param : params) {
            this.parameters.add(new Parameter((String)param.getName(), (String)param.getValue()));
        }
        return this.self();
    }

    @Override
    public T addParam(String key, Object value) {
        this.ensureParameters();
        this.parameters.add(Parameter.of(key, value));
        return this.self();
    }

    private void ensureParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<Parameter>();
        }
    }

    @Override
    public T charset(Charset charset) {
        this.charset = charset;
        return this.self();
    }

    @Override
    public T charset(String charset) {
        return (T)this.charset(Charset.forName(charset));
    }

    T method(Method method) {
        this.method = method;
        return this.self();
    }

    @Override
    public T headers(Map<String, ?> params) {
        this.headers = new ArrayList<Header>();
        for (Map.Entry<String, ?> entry : params.entrySet()) {
            this.headers.add(Header.of(entry.getKey(), entry.getValue()));
        }
        return this.self();
    }

    @Override
    public T headers(Header ... headers) {
        this.headers = new ArrayList<Header>();
        Collections.addAll(this.headers, headers);
        return this.self();
    }

    @Override
    public T headers(List<Header> headers) {
        this.headers = new ArrayList<Header>();
        for (Header header : headers) {
            this.headers.add(header);
        }
        return this.self();
    }

    @Override
    public T addHeader(String key, Object value) {
        this.ensureHeaders();
        this.headers.add(Header.of(key, value));
        return this.self();
    }

    private void ensureHeaders() {
        if (this.headers == null) {
            this.headers = new ArrayList<Header>();
        }
    }

    @Override
    public T auth(String userName, String password) {
        this.authInfo = new AuthInfo(userName, password);
        return this.self();
    }

    @Override
    public T cookies(Map<String, String> cookies) {
        this.cookies = new ArrayList<Cookie>(cookies.size());
        for (Map.Entry<String, String> entry : cookies.entrySet()) {
            this.cookies.add(new Cookie(entry.getKey(), entry.getValue()));
        }
        return this.self();
    }

    @Override
    public T cookies(Cookie ... cookies) {
        this.cookies = new ArrayList<Cookie>(cookies.length);
        Collections.addAll(this.cookies, cookies);
        return this.self();
    }

    @Override
    public T cookies(Collection<Cookie> cookies) {
        this.cookies = new ArrayList<Cookie>(cookies.size());
        for (Cookie cookie : cookies) {
            this.cookies.add(cookie);
        }
        return this.self();
    }

    @Override
    public T addCookie(String name, String value) {
        this.ensureCookies();
        this.cookies.add(new Cookie(name, value));
        return this.self();
    }

    private void ensureCookies() {
        if (this.cookies == null) {
            this.cookies = new ArrayList<Cookie>();
        }
    }

    T session(Session session) {
        this.session = session;
        return this.self();
    }

    protected abstract T self();
}

