/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests.struct;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.dongliu.requests.struct.Pair;

public class MultiMap<K, V, T extends Pair<K, V>>
implements Iterable<T> {
    private List<T> pairs;

    public MultiMap() {
        this.pairs = new ArrayList<T>();
    }

    @SafeVarargs
    public MultiMap(T ... pairs) {
        this.pairs = Arrays.asList(pairs);
    }

    public MultiMap(List<T> pairs) {
        this.pairs = pairs;
    }

    public void add(T pair) {
        this.pairs.add(pair);
    }

    public T getFirst(K key) {
        for (Pair pair : this.pairs) {
            if (!pair.getName().equals(key)) continue;
            return (T)pair;
        }
        return null;
    }

    public Collection<T> get(K key) {
        ArrayList<Pair> list = new ArrayList<Pair>();
        for (Pair pair : this.pairs) {
            if (!pair.getName().equals(key)) continue;
            list.add(pair);
        }
        return list;
    }

    public Collection<T> items() {
        return this.pairs;
    }

    @Override
    public Iterator<T> iterator() {
        return this.pairs.iterator();
    }

    public int size() {
        return this.pairs.size();
    }

    public boolean isEmpty() {
        return this.pairs.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (int i = 0; i < this.pairs.size(); ++i) {
            Pair pair = (Pair)this.pairs.get(i);
            sb.append(pair.getName()).append(": ").append(pair.getValue());
            if (i == this.pairs.size() - 1) continue;
            sb.append(", ");
        }
        sb.append('}');
        return sb.toString();
    }
}

