/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests.struct;

import java.io.File;
import java.io.InputStream;
import java.net.URLConnection;

public class MultiPart {
    private final Type type;
    private final String name;
    private final String mime;
    private final String fileName;
    private final File file;
    private final InputStream in;
    private final byte[] bytes;
    private final String value;

    public MultiPart(String name, String value) {
        this.file = null;
        this.mime = null;
        this.name = name;
        this.type = Type.TEXT;
        this.in = null;
        this.bytes = null;
        this.value = value;
        this.fileName = null;
    }

    public MultiPart(String name, File file) {
        this(name, URLConnection.guessContentTypeFromName(file.getName()), file);
    }

    public MultiPart(String name, String mime, File file) {
        this.file = file;
        this.mime = mime;
        this.name = name;
        this.type = Type.FILE;
        this.in = null;
        this.bytes = null;
        this.value = null;
        this.fileName = file.getName();
    }

    public MultiPart(String name, String mime, String fileName, InputStream in) {
        this.file = null;
        this.in = in;
        this.bytes = null;
        this.mime = mime;
        this.name = name;
        this.type = Type.STREAM;
        this.value = null;
        this.fileName = fileName;
    }

    public MultiPart(String name, String mime, String fileName, byte[] bytes) {
        this.file = null;
        this.in = null;
        this.bytes = bytes;
        this.mime = mime;
        this.name = name;
        this.type = Type.BYTES;
        this.value = null;
        this.fileName = fileName;
    }

    public String getName() {
        return this.name;
    }

    public File getFile() {
        return this.file;
    }

    public String getMime() {
        return this.mime;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Type getType() {
        return this.type;
    }

    public InputStream getIn() {
        return this.in;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String getValue() {
        return this.value;
    }

    public static enum Type {
        FILE,
        STREAM,
        BYTES,
        TEXT;

    }
}

