/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.dongliu.commons.collection.Pair;
import net.dongliu.commons.io.Closables;
import net.dongliu.requests.BasicAuth;
import net.dongliu.requests.Cookie;
import net.dongliu.requests.CookieUtils;
import net.dongliu.requests.CustomCertTrustManager;
import net.dongliu.requests.HttpExecutor;
import net.dongliu.requests.HttpRequest;
import net.dongliu.requests.Proxies;
import net.dongliu.requests.RawResponse;
import net.dongliu.requests.ResponseHeaders;
import net.dongliu.requests.Session;
import net.dongliu.requests.TrustAllTrustManager;
import net.dongliu.requests.Utils;
import net.dongliu.requests.body.RequestBody;
import net.dongliu.requests.exception.RequestsException;

public class URLConnectionExecutor
implements HttpExecutor {
    @Override
    public RawResponse proceed(HttpRequest request) {
        RawResponse response = this.doRequest(request);
        if (!request.isFollowRedirect() || !Utils.isRedirect(response.getStatusCode())) {
            return response;
        }
        response.discardBody();
        int redirectCount = 0;
        URL redirectUrl = request.getUrl();
        while (redirectCount++ < 5) {
            String location = response.getFirstHeader("Location");
            if (location == null) {
                throw new RequestsException("Redirect location not found");
            }
            try {
                redirectUrl = new URL(redirectUrl, location);
            }
            catch (MalformedURLException e) {
                throw new RequestsException("Get redirect url error", e);
            }
            response = request.getSession().get(redirectUrl.toExternalForm()).proxy(request.getProxy()).followRedirect(false).send();
            if (!Utils.isRedirect(response.getStatusCode())) {
                return response;
            }
            response.discardBody();
        }
        throw new RequestsException("Too many redirect");
    }

    private RawResponse doRequest(HttpRequest request) {
        Stream<Pair> stream;
        Object stream1;
        String cookieStr;
        HttpURLConnection conn;
        Charset charset = request.getCharset();
        URL url = request.getUrl();
        Proxy proxy = request.getProxy();
        RequestBody<?> body = request.getBody();
        Session session = request.getSession();
        String protocol = url.getProtocol();
        String host = url.getHost();
        String effectivePath = CookieUtils.effectivePath(url.getPath());
        try {
            conn = proxy != null ? (HttpURLConnection)url.openConnection(proxy) : (HttpURLConnection)url.openConnection();
        }
        catch (MalformedURLException e) {
            throw new RequestsException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (conn instanceof HttpsURLConnection) {
            X509TrustManager trustManager = null;
            if (!request.isVerify()) {
                trustManager = new TrustAllTrustManager();
            } else if (!request.getCerts().isEmpty()) {
                trustManager = new CustomCertTrustManager(request.getCerts());
            }
            if (trustManager != null) {
                SSLContext sSLContext;
                try {
                    sSLContext = SSLContext.getInstance("SSL");
                    sSLContext.init(null, new TrustManager[]{trustManager}, new SecureRandom());
                }
                catch (KeyManagementException | NoSuchAlgorithmException e) {
                    throw new RequestsException(e);
                }
                SSLSocketFactory ssf = sSLContext.getSocketFactory();
                ((HttpsURLConnection)conn).setSSLSocketFactory(ssf);
            }
        }
        try {
            conn.setRequestMethod(request.getMethod());
        }
        catch (ProtocolException e) {
            throw new RequestsException(e);
        }
        conn.setReadTimeout(request.getSocksTimeout());
        conn.setConnectTimeout(request.getConnectTimeout());
        conn.setInstanceFollowRedirects(false);
        if (body != null) {
            conn.setDoOutput(true);
            String contentType = body.getContentType();
            if (contentType != null) {
                if (body.isIncludeCharset()) {
                    contentType = contentType + "; charset=" + request.getCharset().name().toLowerCase();
                }
                conn.setRequestProperty("Content-Type", contentType);
            }
        }
        if (!request.getUserAgent().isEmpty()) {
            conn.setRequestProperty("User-Agent", request.getUserAgent());
        }
        if (request.isCompress()) {
            conn.setRequestProperty("Accept-Encoding", "gzip, deflate");
        }
        if (request.getBasicAuth() != null) {
            conn.setRequestProperty("Authorization", request.getBasicAuth().encode());
        }
        if (proxy != null && proxy instanceof Proxies.AuthenticationHttpProxy) {
            BasicAuth basicAuth = ((Proxies.AuthenticationHttpProxy)proxy).getBasicAuth();
            conn.setRequestProperty("Proxy-Authorization", basicAuth.encode());
        }
        if (!(request.getCookies().isEmpty() && session.getCookies().isEmpty() || (cookieStr = Stream.concat(stream1 = request.getCookies().stream(), stream = session.matchedCookies(protocol, host, effectivePath).map(c -> Pair.of((Object)c.getName(), (Object)c.getValue()))).map(c -> (String)c.getKey() + "=" + c.getValue()).collect(Collectors.joining("; "))).isEmpty())) {
            conn.setRequestProperty("Cookie", cookieStr);
        }
        for (Map.Entry entry : request.getHeaders()) {
            conn.setRequestProperty((String)entry.getKey(), String.valueOf(entry.getValue()));
        }
        try {
            conn.connect();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        try {
            if (body != null) {
                this.sendBody(body, conn, charset);
            }
            return this.getResponse(conn, session, request.getMethod(), host, effectivePath);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            conn.disconnect();
        }
    }

    private RawResponse getResponse(HttpURLConnection conn, Session session, String method, String host, String path) throws IOException {
        int status = conn.getResponseCode();
        ArrayList<Map.Entry<String, String>> headerList = new ArrayList<Map.Entry<String, String>>();
        HashSet<Cookie> cookies = new HashSet<Cookie>();
        int index = 0;
        while (true) {
            String key = conn.getHeaderFieldKey(index);
            String value = conn.getHeaderField(index);
            if (value == null) break;
            ++index;
            if (key == null) continue;
            headerList.add((Map.Entry<String, String>)Pair.of((Object)key, (Object)value));
            if (!key.equalsIgnoreCase("Set-Cookie")) continue;
            cookies.add(CookieUtils.parseCookieHeader(host, path, value));
        }
        ResponseHeaders headers = new ResponseHeaders(headerList);
        InputStream input = status >= 200 && status < 400 ? conn.getInputStream() : conn.getErrorStream();
        input = this.wrapCompressBody(status, method, headers, input);
        session.updateCookie(cookies);
        return new RawResponse(status, headers, cookies, input, conn);
    }

    private InputStream wrapCompressBody(int status, String method, ResponseHeaders headers, InputStream input) {
        if (method.equals("HEAD") || status >= 100 && status < 200 || status == 304 || status == 204) {
            return input;
        }
        String contentEncoding = headers.getFirstHeader("Content-Encoding");
        if (contentEncoding == null) {
            return input;
        }
        switch (contentEncoding) {
            case "gzip": {
                try {
                    return new GZIPInputStream(input);
                }
                catch (IOException e) {
                    Closables.closeQuietly((AutoCloseable)input);
                    throw new UncheckedIOException(e);
                }
            }
            case "deflate": {
                return new DeflaterInputStream(input);
            }
        }
        return input;
    }

    private void sendBody(RequestBody body, HttpURLConnection conn, Charset requestCharset) {
        try (OutputStream os = conn.getOutputStream();){
            body.writeBody(os, requestCharset);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

