/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests.body;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import net.dongliu.requests.body.BytesRequestBody;
import net.dongliu.requests.body.FileRequestBody;
import net.dongliu.requests.body.FormRequestBody;
import net.dongliu.requests.body.InputStreamRequestBody;
import net.dongliu.requests.body.JsonRequestBody;
import net.dongliu.requests.body.MultiPartRequestBody;
import net.dongliu.requests.body.Part;
import net.dongliu.requests.body.StringRequestBody;

public abstract class RequestBody<T> {
    private final T body;
    private String contentType;
    private final boolean includeCharset;

    public RequestBody(T body, String contentType, boolean includeCharset) {
        this.body = body;
        this.contentType = contentType;
        this.includeCharset = includeCharset;
    }

    public T getBody() {
        return this.body;
    }

    public RequestBody<T> setContentType(String contentType) {
        this.contentType = Objects.requireNonNull(contentType);
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isIncludeCharset() {
        return this.includeCharset;
    }

    public abstract void writeBody(OutputStream var1, Charset var2) throws IOException;

    public static <T> RequestBody<T> json(T value) {
        return new JsonRequestBody<T>(value);
    }

    public static RequestBody<String> text(String value) {
        return new StringRequestBody(Objects.requireNonNull(value));
    }

    public static RequestBody<Collection<? extends Map.Entry<String, ?>>> form(Collection<? extends Map.Entry<String, ?>> value) {
        return new FormRequestBody(Objects.requireNonNull(value));
    }

    public static RequestBody<byte[]> bytes(byte[] value) {
        return new BytesRequestBody(Objects.requireNonNull(value));
    }

    public static RequestBody<InputStream> inputStream(InputStream in) {
        return new InputStreamRequestBody(Objects.requireNonNull(in));
    }

    public static RequestBody<File> file(File file) {
        return new FileRequestBody(Objects.requireNonNull(file));
    }

    public static RequestBody<Collection<? extends Part>> multiPart(Collection<? extends Part> parts) {
        return new MultiPartRequestBody(Objects.requireNonNull(parts));
    }
}

