/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests.json;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.lang.reflect.Type;
import net.dongliu.requests.json.JsonProvider;

public class JacksonProvider
implements JsonProvider {
    private final ObjectMapper objectMapper;

    public JacksonProvider() {
        this(new ObjectMapper());
    }

    public JacksonProvider(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public void marshal(Writer writer, Object value) {
        try {
            this.objectMapper.writeValue(writer, value);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public <T> T unmarshal(Reader reader, Type type) {
        JavaType javaType = this.objectMapper.getTypeFactory().constructType(type);
        try {
            return (T)this.objectMapper.readValue(reader, javaType);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

