/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests.json;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dongliu.requests.json.GsonProvider;
import net.dongliu.requests.json.JacksonProvider;
import net.dongliu.requests.json.JsonProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonLookup {
    private static Logger logger = LoggerFactory.getLogger(JsonLookup.class);
    private static JsonLookup jsonLookup = new JsonLookup();
    @Nullable
    private JsonProvider jsonProvider;
    private boolean jsonlooked;

    private JsonLookup() {
    }

    public static JsonLookup getInstance() {
        return jsonLookup;
    }

    public synchronized void setJsonProvider(@Nonnull JsonProvider jsonProvider) {
        this.jsonProvider = Objects.requireNonNull(jsonProvider);
        logger.info("Set json provider to {}", (Object)jsonProvider.getClass().getName());
    }

    boolean hasGson() {
        try {
            Class.forName("com.google.gson.Gson");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    JsonProvider gsonProvider() {
        return new GsonProvider();
    }

    boolean hasJackson() {
        try {
            Class.forName("com.fasterxml.jackson.databind.ObjectMapper");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    JsonProvider jacksonProvider() {
        return new JacksonProvider();
    }

    @Nonnull
    public synchronized JsonProvider lookup() {
        if (this.jsonProvider != null) {
            return this.jsonProvider;
        }
        if (this.hasJackson()) {
            logger.info("Use default jackson provider to deal with json");
            this.jsonProvider = this.jacksonProvider();
            return this.jsonProvider;
        }
        if (this.hasGson()) {
            logger.info("Use default gson provider to deal with json");
            this.jsonProvider = this.gsonProvider();
            return this.jsonProvider;
        }
        throw new RuntimeException("No json provider found");
    }
}

