/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import net.dongliu.requests.Parameter;

public class Cookie
extends Parameter<String>
implements Map.Entry<String, String>,
Serializable {
    private static final long serialVersionUID = -287880603936079757L;
    private final String domain;
    private final String path;
    private final long expiry;
    private final boolean secure;
    private final boolean hostOnly;

    public Cookie(String domain, String path, String name, String value, long expiry, boolean secure, boolean hostOnly) {
        super(name, value);
        this.domain = Objects.requireNonNull(domain);
        this.path = Objects.requireNonNull(path);
        this.expiry = expiry;
        this.secure = secure;
        this.hostOnly = hostOnly;
    }

    public boolean expired(long now) {
        return this.expiry != 0L && this.expiry < now;
    }

    @Deprecated
    public String getDomain() {
        return this.domain;
    }

    @Deprecated
    public boolean isSecure() {
        return this.secure;
    }

    @Deprecated
    public long getExpiry() {
        return this.expiry;
    }

    @Deprecated
    public String getPath() {
        return this.path;
    }

    @Deprecated
    public boolean isHostOnly() {
        return this.hostOnly;
    }

    public String domain() {
        return this.domain;
    }

    public boolean secure() {
        return this.secure;
    }

    public long expiry() {
        return this.expiry;
    }

    public String path() {
        return this.path;
    }

    public boolean hostOnly() {
        return this.hostOnly;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cookie cookie = (Cookie)o;
        if (this.expiry != cookie.expiry) {
            return false;
        }
        if (this.secure != cookie.secure) {
            return false;
        }
        if (this.hostOnly != cookie.hostOnly) {
            return false;
        }
        if (!this.domain.equals(cookie.domain)) {
            return false;
        }
        if (!this.path.equals(cookie.path)) {
            return false;
        }
        if (!this.name.equals(cookie.name)) {
            return false;
        }
        return ((String)this.value).equals(cookie.value);
    }

    @Override
    public int hashCode() {
        int result = this.domain.hashCode();
        result = 31 * result + this.path.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + ((String)this.value).hashCode();
        result = 31 * result + (int)(this.expiry ^ this.expiry >>> 32);
        result = 31 * result + (this.secure ? 1 : 0);
        result = 31 * result + (this.hostOnly ? 1 : 0);
        return result;
    }

    @Override
    public String toString() {
        return "Cookie{domain='" + this.domain + '\'' + ", path='" + this.path + '\'' + ", name='" + this.name + '\'' + ", value='" + (String)this.value + '\'' + ", expiry=" + this.expiry + ", secure=" + this.secure + ", hostOnly=" + this.hostOnly + '}';
    }
}

