/*
 * Decompiled with CFR 0.152.
 */
package net.donky.core.assets;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Environment;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import net.donky.core.DonkyCore;
import net.donky.core.DonkyException;
import net.donky.core.DonkyListener;
import net.donky.core.DonkyResultListener;
import net.donky.core.account.DonkyAccountController;
import net.donky.core.account.UserDetails;
import net.donky.core.assets.NotificationImageLoader;
import net.donky.core.assets.utils.ImageUtils;
import net.donky.core.assets.utils.MimeUtils;
import net.donky.core.helpers.IdHelper;
import net.donky.core.helpers.MainThreadHandlerHelper;
import net.donky.core.logging.DLog;
import net.donky.core.model.DonkyDataController;
import net.donky.core.network.DonkyNetworkController;
import net.donky.core.network.assets.Asset;
import net.donky.core.network.assets.AssetType;
import net.donky.core.network.restapi.secured.UploadAssetResponse;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class DonkyAssetController {
    public final String downloadsFolder;
    public String applicationDownloadsFolder;
    private static final int MAX_AVATAR_WIDTH = 96;
    private static final int MAX_AVATAR_HEIGHT = 96;
    private static final String ASSET_URL_ID_REPLACEMENT = "{0}";
    private static final int SUCCESSFUL_DOWNLOAD = 200;
    private DLog log = new DLog("DonkyAssetController");
    private OkHttpClient okHttpClient;
    private Context context;

    private DonkyAssetController() {
        this.downloadsFolder = Environment.getExternalStorageDirectory() + "/" + Environment.DIRECTORY_DOWNLOADS;
        this.applicationDownloadsFolder = this.downloadsFolder + "/";
    }

    public static DonkyAssetController getInstance() {
        return SingletonHolder.INSTANCE;
    }

    void init(Context context, OkHttpClient okHttpClient) {
        this.context = context;
        this.applicationDownloadsFolder = this.applicationDownloadsFolder + DonkyAssetController.getFolderName(context) + "/";
        if (okHttpClient != null) {
            this.okHttpClient = okHttpClient;
        } else {
            this.log.error("Missing okHttpClient instance.");
        }
    }

    public void uploadMessageAsset(File file, final DonkyResultListener<Asset> donkyResultListener) {
        String mimeType;
        if (file != null && !TextUtils.isEmpty((CharSequence)(mimeType = MimeUtils.getMimeType(Uri.fromFile((File)file).toString())))) {
            final Asset assetDetails = new Asset(file.getName(), mimeType, file.length());
            assetDetails.setFilePath(file.getAbsolutePath());
            AssetType assetType = AssetType.MessageAsset;
            final MainThreadHandlerHelper handler = new MainThreadHandlerHelper();
            DonkyNetworkController.getInstance().uploadAsset(assetType, mimeType, file, (DonkyResultListener)new DonkyResultListener<UploadAssetResponse>(){

                public void success(UploadAssetResponse uploadAssetResponse) {
                    if (uploadAssetResponse != null && !TextUtils.isEmpty((CharSequence)uploadAssetResponse.getAssetId())) {
                        assetDetails.setAssetId(uploadAssetResponse.getAssetId());
                        handler.notifySuccess(donkyResultListener, (Object)assetDetails);
                    }
                }

                public void error(DonkyException donkyException, Map<String, String> validationErrors) {
                    handler.notifyError(donkyResultListener, donkyException, validationErrors);
                }
            });
        }
    }

    public void uploadMessageAsset(final byte[] bytesArray, final String mimeType, final @Nullable String name, final DonkyResultListener<Asset> donkyResultListener) {
        if (bytesArray != null && bytesArray.length > 0 && !TextUtils.isEmpty((CharSequence)mimeType)) {
            AssetType assetType = AssetType.MessageAsset;
            final MainThreadHandlerHelper handler = new MainThreadHandlerHelper();
            DonkyNetworkController.getInstance().uploadAsset(assetType, mimeType, bytesArray, (DonkyResultListener)new DonkyResultListener<UploadAssetResponse>(){

                public void success(UploadAssetResponse uploadAssetResponse) {
                    if (uploadAssetResponse != null && !TextUtils.isEmpty((CharSequence)uploadAssetResponse.getAssetId())) {
                        Asset assetDetails = new Asset(name, mimeType, (long)bytesArray.length);
                        assetDetails.setAssetId(uploadAssetResponse.getAssetId());
                        handler.notifySuccess(donkyResultListener, (Object)assetDetails);
                    } else {
                        handler.notifyError(donkyResultListener, new DonkyException("No asset id returned from network"), null);
                    }
                }

                public void error(DonkyException donkyException, Map<String, String> validationErrors) {
                    handler.notifyError(donkyResultListener, donkyException, validationErrors);
                }
            });
        }
    }

    public void uploadAccountAvatar(final Bitmap bitmap, final DonkyResultListener<String> donkyResultListener) {
        if (bitmap != null) {
            DonkyCore.getInstance().processInBackground(new Runnable(){

                @Override
                public void run() {
                    byte[] bytes = null;
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    Bitmap bitmapToSend = ImageUtils.resizeBitmap(bitmap, 96, 96, true);
                    if (bitmapToSend != null) {
                        bitmapToSend.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
                        bytes = stream.toByteArray();
                    }
                    if (bytes != null && bytes.length > 0) {
                        final MainThreadHandlerHelper handler = new MainThreadHandlerHelper();
                        AssetType assetType = AssetType.AccountAvatar;
                        DonkyNetworkController.getInstance().uploadAsset(assetType, "image/png", bytes, (DonkyResultListener)new DonkyResultListener<UploadAssetResponse>(){

                            public void success(final UploadAssetResponse uploadAssetResponse) {
                                if (uploadAssetResponse != null && !TextUtils.isEmpty((CharSequence)uploadAssetResponse.getAssetId())) {
                                    UserDetails userDetails = DonkyAccountController.getInstance().getCurrentDeviceUser();
                                    if (TextUtils.isEmpty((CharSequence)userDetails.getUserDisplayName())) {
                                        userDetails.setUserDisplayName(userDetails.getUserId());
                                    }
                                    userDetails.setUserAvatarId(uploadAssetResponse.getAssetId());
                                    DonkyAccountController.getInstance().updateUserDetails(userDetails, new DonkyListener(){

                                        public void success() {
                                            handler.notifySuccess(donkyResultListener, (Object)uploadAssetResponse.getAssetId());
                                        }

                                        public void error(DonkyException donkyException, Map<String, String> validationErrors) {
                                            handler.notifyError(donkyResultListener, donkyException, validationErrors);
                                        }
                                    });
                                } else {
                                    handler.notifyError(donkyResultListener, new DonkyException("Empty asset id in response."), null);
                                }
                            }

                            public void error(DonkyException donkyException, Map<String, String> validationErrors) {
                                handler.notifyError(donkyResultListener, donkyException, validationErrors);
                            }
                        });
                    }
                }
            });
        }
    }

    public void downloadImageAsset(String assetId, final NotificationImageLoader listener) {
        if (!TextUtils.isEmpty((CharSequence)assetId) && this.isInitialised()) {
            try {
                String path = this.getAssetUrl(assetId);
                Request request = new Request.Builder().url(path).build();
                this.okHttpClient.newCall(request).enqueue(new Callback(){

                    public void onFailure(Call call, IOException e) {
                        if (listener != null) {
                            listener.failure(e);
                        }
                    }

                    public void onResponse(Call call, Response response) throws IOException {
                        if (response != null && response.code() == 200) {
                            ResponseBody responseBody = response.body();
                            if (responseBody != null) {
                                InputStream inputStream = responseBody.byteStream();
                                if (listener != null) {
                                    listener.downloadCompleted(BitmapFactory.decodeStream((InputStream)inputStream));
                                }
                            } else if (listener != null) {
                                listener.failure(new Exception("Error downloading image. Null response body"));
                            }
                        } else if (listener != null) {
                            listener.failure(new Exception("Error downloading image."));
                        }
                    }
                });
            }
            catch (Exception exception) {
                this.log.error("Error downloading avatar", exception);
                if (listener != null) {
                    listener.failure(exception);
                }
            }
        } else if (listener != null) {
            listener.failure(new Exception("Empty asset id or network client not initialised."));
        }
    }

    public void downloadAsset(String assetId, final DonkyResultListener<InputStream> listener) {
        block2: {
            try {
                String path = this.getAssetUrl(assetId);
                Request request = new Request.Builder().url(path).build();
                this.okHttpClient.newCall(request).enqueue(new Callback(){

                    public void onFailure(Call call, IOException e) {
                        DonkyException donkyException = new DonkyException("Failed to download file");
                        donkyException.initCause((Throwable)e);
                        if (listener != null) {
                            listener.error(donkyException, null);
                        }
                    }

                    public void onResponse(Call call, Response response) throws IOException {
                        if (response != null && response.code() == 200) {
                            ResponseBody responseBody = response.body();
                            if (responseBody != null) {
                                InputStream inputStream = responseBody.byteStream();
                                if (listener != null) {
                                    if (inputStream != null) {
                                        listener.success((Object)inputStream);
                                    } else {
                                        listener.error(new DonkyException("Null response body"), null);
                                    }
                                }
                            } else if (listener != null) {
                                listener.error(new DonkyException("Null response body"), null);
                            }
                        } else if (listener != null) {
                            listener.error(new DonkyException("Download failed"), null);
                        }
                    }
                });
            }
            catch (Exception exception) {
                this.log.error("Error downloading avatar", exception);
                if (listener == null) break block2;
                listener.error(new DonkyException("Download failed"), null);
            }
        }
    }

    public void downloadAssetAndSave(final String assetId, final String mimeType, final @Nullable String name, final @Nullable DonkyResultListener<Asset> donkyResultListener) {
        if (!TextUtils.isEmpty((CharSequence)assetId) && !TextUtils.isEmpty((CharSequence)mimeType)) {
            this.downloadAsset(assetId, new DonkyResultListener<InputStream>(){

                public void success(InputStream stream) {
                    if (stream != null) {
                        DonkyAssetController.this.saveStream(assetId, mimeType, name, stream, (DonkyResultListener<Asset>)donkyResultListener);
                    }
                }

                public void error(DonkyException donkyException, Map<String, String> validationErrors) {
                    new MainThreadHandlerHelper().notifyError(donkyResultListener, donkyException, validationErrors);
                }
            });
        } else {
            new MainThreadHandlerHelper().notifyError(donkyResultListener, new DonkyException("Missing asset id or mime type."), null);
        }
    }

    private String getPathToSaveStream(String assetId, String fileName, String mimeType) {
        String finalName;
        if (!TextUtils.isEmpty((CharSequence)fileName)) {
            finalName = fileName;
        } else {
            finalName = !TextUtils.isEmpty((CharSequence)assetId) ? assetId : IdHelper.generateId();
            String ext = MimeTypeMap.getSingleton().getExtensionFromMimeType(mimeType);
            if (!TextUtils.isEmpty((CharSequence)ext)) {
                finalName = finalName + "." + ext;
            }
        }
        return this.applicationDownloadsFolder + finalName;
    }

    private void saveStream(final String assetId, final String mimeType, final @Nullable String fileName, final InputStream stream, final @Nullable DonkyResultListener<Asset> donkyResultListener) {
        if (this.initDownloadFolder()) {
            DonkyCore.getInstance().processInBackground(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String path = DonkyAssetController.this.getPathToSaveStream(assetId, fileName, mimeType);
                    File file = new File(path);
                    FileOutputStream outStream = null;
                    MainThreadHandlerHelper handler = new MainThreadHandlerHelper();
                    try {
                        try {
                            int bytesRead;
                            outStream = new FileOutputStream(file);
                            byte[] buffer = new byte[8192];
                            while ((bytesRead = stream.read(buffer)) != -1) {
                                ((OutputStream)outStream).write(buffer, 0, bytesRead);
                            }
                        }
                        catch (Exception exception) {
                            DonkyAssetController.this.log.error("Error writing to file", exception);
                            DonkyException donkyException = new DonkyException("Error writing to file");
                            donkyException.initCause((Throwable)exception);
                            handler.notifyError(donkyResultListener, donkyException, null);
                        }
                        finally {
                            if (outStream != null) {
                                ((OutputStream)outStream).close();
                            }
                            stream.close();
                            Asset assetDetails = new Asset(file.getName(), mimeType, file.length());
                            assetDetails.setAssetId(assetId);
                            assetDetails.setFilePath(file.getAbsolutePath());
                            handler.notifySuccess(donkyResultListener, (Object)assetDetails);
                        }
                    }
                    catch (Exception exception) {
                        DonkyAssetController.this.log.error("Error closing file", exception);
                        DonkyException donkyException = new DonkyException("Error closing file");
                        donkyException.initCause((Throwable)exception);
                        handler.notifyError(donkyResultListener, donkyException, null);
                    }
                }
            });
        }
    }

    private boolean initDownloadFolder() {
        File folder = new File(this.applicationDownloadsFolder);
        if (!folder.exists() || !folder.isDirectory()) {
            folder.mkdirs();
        }
        return folder.exists();
    }

    private static String getFolderName(Context context) {
        String name = null;
        ApplicationInfo info = context.getApplicationInfo();
        if (info != null) {
            int stringId = info.labelRes;
            try {
                name = context.getString(stringId);
            }
            catch (Resources.NotFoundException notFoundException) {
                // empty catch block
            }
        }
        if (TextUtils.isEmpty(name)) {
            name = context.getPackageName();
        }
        if (TextUtils.isEmpty(name)) {
            name = "Donky";
        }
        name = "temp_" + name;
        return name;
    }

    public Bitmap downloadImageAsset(String assetId) {
        if (!TextUtils.isEmpty((CharSequence)assetId) && this.isInitialised()) {
            try {
                String path = this.getAssetUrl(assetId);
                Request request = new Request.Builder().url(path).build();
                Response response = this.okHttpClient.newCall(request).execute();
                if (response != null) {
                    ResponseBody responseBody = response.body();
                    InputStream inputStream = responseBody.byteStream();
                    Resources resources = this.context.getResources();
                    int size = ImageUtils.getPixelsFromDP(resources, 128.0f);
                    return ImageUtils.resizeBitmap(BitmapFactory.decodeStream((InputStream)inputStream), size, size, true);
                }
            }
            catch (Exception exception) {
                this.log.error("Error downloading avatar", exception);
            }
        }
        return null;
    }

    public String getAssetUrl(String assetId) {
        if (!TextUtils.isEmpty((CharSequence)assetId)) {
            String query;
            try {
                query = URLEncoder.encode(assetId, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                this.log.error("Error URL encoding the asset Id.", (Exception)e);
                query = assetId;
            }
            String urlFormat = (String)DonkyDataController.getInstance().getConfigurationDAO().getConfigurationItems().get("AssetDownloadUrlFormat");
            if (!TextUtils.isEmpty((CharSequence)urlFormat) && !TextUtils.isEmpty((CharSequence)query)) {
                return urlFormat.replace(ASSET_URL_ID_REPLACEMENT, query);
            }
        }
        return null;
    }

    public boolean isInitialised() {
        return this.okHttpClient != null;
    }

    private static class SingletonHolder {
        private static final DonkyAssetController INSTANCE = new DonkyAssetController();

        private SingletonHolder() {
        }
    }
}

