/*
 * Decompiled with CFR 0.152.
 */
package net.donky.core.assets;

import android.app.Application;
import java.util.concurrent.atomic.AtomicBoolean;
import net.donky.core.DonkyCore;
import net.donky.core.DonkyException;
import net.donky.core.DonkyListener;
import net.donky.core.ModuleDefinition;
import net.donky.core.assets.DonkyAssetController;
import net.donky.core.events.CoreInitialisedSuccessfullyEvent;
import net.donky.core.events.DonkyEventListener;
import net.donky.core.network.restapi.RestClient;

public class DonkyAssets {
    private final String version = "2.0.0.2";
    private static final AtomicBoolean initialised = new AtomicBoolean(false);

    private DonkyAssets() {
    }

    public static DonkyAssets getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public static void initialiseDonkyAssets(Application application, DonkyListener donkyListener) {
        DonkyAssets.getInstance().init(application, donkyListener);
    }

    private void init(final Application application, DonkyListener donkyListener) {
        block6: {
            if (!initialised.get()) {
                try {
                    DonkyCore.registerModule((ModuleDefinition)new ModuleDefinition(DonkyAssets.class.getSimpleName(), "2.0.0.2"));
                    DonkyCore.subscribeToLocalEvent((DonkyEventListener)new DonkyEventListener<CoreInitialisedSuccessfullyEvent>(CoreInitialisedSuccessfullyEvent.class){

                        public void onDonkyEvent(CoreInitialisedSuccessfullyEvent event) {
                            DonkyAssetController.getInstance().init(application.getApplicationContext(), RestClient.getInstance().getOkHttpClient());
                        }
                    });
                    initialised.set(true);
                    if (donkyListener != null) {
                        donkyListener.success();
                    }
                    break block6;
                }
                catch (Exception e) {
                    DonkyException donkyException = new DonkyException("Error initialising Automation Module");
                    donkyException.initCause((Throwable)e);
                    if (donkyListener != null) {
                        donkyListener.error(donkyException, null);
                    }
                    break block6;
                }
            }
            if (donkyListener != null) {
                donkyListener.success();
            }
        }
    }

    private static class SingletonHolder {
        private static final DonkyAssets INSTANCE = new DonkyAssets();

        private SingletonHolder() {
        }
    }
}

