/*
 * Decompiled with CFR 0.152.
 */
package net.donky.core.assets;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.os.Build;
import net.donky.core.assets.utils.ImageUtils;
import net.donky.core.network.assets.ImageHelper;

public abstract class NotificationImageLoader {
    int width;
    int height;

    public NotificationImageLoader(Context context) {
        int size;
        Resources resources = context.getResources();
        this.width = size = ImageUtils.getPixelsFromDP(resources, 128.0f);
        this.height = size;
        if (Build.VERSION.SDK_INT >= 11) {
            this.width = (int)resources.getDimension(0x1050005);
            this.height = (int)resources.getDimension(17104902);
        }
    }

    public NotificationImageLoader(Context context, int dps) {
        int size;
        Resources resources = context.getResources();
        this.width = size = ImageHelper.getPixelsFromDP((Resources)resources, (float)dps);
        this.height = size;
        if (Build.VERSION.SDK_INT >= 11) {
            this.width = (int)resources.getDimension(0x1050005);
            this.height = (int)resources.getDimension(17104902);
        }
    }

    public abstract void success(Bitmap var1);

    public abstract void failure(Exception var1);

    void downloadCompleted(Bitmap bitmap) {
        this.success(ImageHelper.resizeBitmap((Bitmap)bitmap, (int)this.width, (int)this.height, (boolean)true));
    }
}

