/*
 * Decompiled with CFR 0.152.
 */
package net.donky.core.assets.utils;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Point;

public class ImageUtils {
    public static int getPixelsFromDP(Resources resources, float dps) {
        float scale = resources.getDisplayMetrics().density;
        return (int)(dps * scale + 0.5f);
    }

    public static Bitmap resizeBitmap(Bitmap b, int maxWidth, int maxHeight, boolean allowLossOfPrecision) {
        Point p;
        Bitmap resized = b;
        if (resized != null && (p = ImageUtils.scaleKeepingAspectRatio(b, maxWidth, maxHeight, allowLossOfPrecision)) != null) {
            try {
                resized = Bitmap.createScaledBitmap((Bitmap)b, (int)p.x, (int)p.y, (boolean)true);
            }
            catch (OutOfMemoryError e) {
                resized = b;
            }
        }
        return resized;
    }

    private static Point scaleKeepingAspectRatio(Bitmap bitmap, int maxWidth, int maxHeight, boolean allowLossOfDetails) {
        int oldWidth = bitmap.getWidth();
        int oldHeight = bitmap.getHeight();
        if (oldWidth > maxWidth || oldHeight > maxHeight || allowLossOfDetails) {
            Point size = new Point();
            float scaleWidth = 1.0f;
            float scaleHeight = 1.0f;
            if (oldWidth > maxWidth || allowLossOfDetails) {
                scaleWidth = (float)maxWidth / (float)oldWidth;
            }
            if (oldHeight > maxHeight || allowLossOfDetails) {
                scaleHeight = (float)maxHeight / (float)oldHeight;
            }
            float scale = Math.min(scaleWidth, scaleHeight);
            size.x = (int)((float)oldWidth * scale);
            size.y = (int)((float)oldHeight * scale);
            return size;
        }
        return null;
    }
}

