/*
 * Decompiled with CFR 0.152.
 */
package net.donky.location;

import android.app.Application;
import android.content.Context;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.donky.core.DonkyCore;
import net.donky.core.DonkyException;
import net.donky.core.DonkyListener;
import net.donky.core.ModuleDefinition;
import net.donky.core.NotificationBatchListener;
import net.donky.core.Subscription;
import net.donky.core.events.ApplicationStartEvent;
import net.donky.core.events.ApplicationStopEvent;
import net.donky.core.events.DonkyEventListener;
import net.donky.core.network.ServerNotification;
import net.donky.location.DonkyLocationController;
import net.donky.location.NotificationHandler;

public class DonkyLocation {
    private final String version = "2.0.0.1";
    public static final String TAG = DonkyLocation.class.getSimpleName();
    private Context context;
    private static final AtomicBoolean initialised = new AtomicBoolean(false);

    private DonkyLocation() {
    }

    public static DonkyLocation getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public static void initialiseDonkyLocation(Application application, DonkyListener donkyListener) {
        DonkyLocation.getInstance().init(application.getApplicationContext(), donkyListener);
    }

    private void init(Context applicationContext, DonkyListener donkyListener) {
        this.context = applicationContext;
        if (!initialised.get()) {
            try {
                DonkyLocationController.getInstance().init(this.context);
                DonkyCore.getInstance().registerService("Location", (Object)DonkyLocationController.getInstance());
                DonkyCore.registerModule((ModuleDefinition)new ModuleDefinition(DonkyLocation.class.getSimpleName(), "2.0.0.1"));
                initialised.set(true);
                if (donkyListener != null) {
                    donkyListener.success();
                }
                DonkyCore.subscribeToLocalEvent((DonkyEventListener)new DonkyEventListener<ApplicationStopEvent>(ApplicationStopEvent.class){

                    public void onDonkyEvent(ApplicationStopEvent event) {
                        DonkyLocationController.getInstance().stopAutomaticLocationUpdatesTimer();
                        DonkyLocationController.getInstance().appStopped();
                    }
                });
                DonkyCore.subscribeToLocalEvent((DonkyEventListener)new DonkyEventListener<ApplicationStartEvent>(ApplicationStartEvent.class){

                    public void onDonkyEvent(ApplicationStartEvent event) {
                        DonkyLocationController.getInstance().startAutomaticLocationUpdatesTimer();
                        DonkyLocationController.getInstance().sendLocationUpdate(null);
                    }
                });
                LinkedList<Subscription> subscriptions = new LinkedList<Subscription>();
                subscriptions.add(new Subscription("LocationRequest", (NotificationBatchListener)new NotificationBatchListener<ServerNotification>(){

                    public void onNotification(ServerNotification notification) {
                    }

                    public void onNotification(List<ServerNotification> notifications) {
                        new NotificationHandler().handleLocationRequest(notifications);
                    }
                }));
                subscriptions.add(new Subscription("UserLocation", (NotificationBatchListener)new NotificationBatchListener<ServerNotification>(){

                    public void onNotification(ServerNotification notification) {
                    }

                    public void onNotification(List<ServerNotification> notifications) {
                        new NotificationHandler().handleUserLocation(notifications);
                    }
                }));
                DonkyCore.subscribeToDonkyNotifications((ModuleDefinition)new ModuleDefinition(DonkyLocation.class.getSimpleName(), "2.0.0.1"), subscriptions, (boolean)true);
            }
            catch (Exception e) {
                DonkyException donkyException = new DonkyException("Error initialising DonkyLocation Module");
                donkyException.initCause((Throwable)e);
                if (donkyListener != null) {
                    donkyListener.error(donkyException, null);
                }
            }
        } else if (donkyListener != null) {
            donkyListener.success();
        }
    }

    public Context getContext() {
        return this.context;
    }

    private static class SingletonHolder {
        private static final DonkyLocation INSTANCE = new DonkyLocation();

        private SingletonHolder() {
        }
    }
}

