/*
 * Decompiled with CFR 0.152.
 */
package net.donky.location;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Dialog;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.donky.core.DonkyException;
import net.donky.core.DonkyListener;
import net.donky.core.logging.DLog;
import net.donky.core.model.AbstractLastLocation;
import net.donky.core.network.ClientNotification;
import net.donky.core.network.DonkyNetworkController;
import net.donky.location.DonkyLocation;
import net.donky.location.TargetUser;
import net.donky.location.internal.LocationClientNotification;
import net.donky.location.internal.LocationUpdateTimer;
import net.donky.location.internal.LocationUpdatesCallback;
import net.donky.location.internal.PollingProfile;

public class DonkyLocationController
extends AbstractLastLocation
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
LocationListener {
    private DLog log;
    private Context context;
    private GoogleApiClient googleApiClient;
    private PollingProfile pollingProfile;
    private ConcurrentLinkedQueue<LocationUpdatesCallback> locationUpdateListeners;
    private ConcurrentLinkedQueue<Pair<LocationRequest, LocationUpdatesCallback>> customLocationUpdateListeners;
    private LocationUpdateTimer timer;
    private boolean shouldAutomaticallySendLocation = false;

    public static DonkyLocationController getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void init(Context context) {
        this.context = context;
        this.googleApiClient = this.getLocationAPI();
        this.log = new DLog("LocationController");
        this.pollingProfile = new PollingProfile();
        this.locationUpdateListeners = new ConcurrentLinkedQueue();
        this.customLocationUpdateListeners = new ConcurrentLinkedQueue();
        this.timer = new LocationUpdateTimer(context);
    }

    private DonkyLocationController() {
    }

    public void setPollingProfile(int interval, int fastestInterval, int priority, int distanceTo) {
        this.pollingProfile = new PollingProfile(interval, fastestInterval, priority, distanceTo);
    }

    private GoogleApiClient getLocationAPI() {
        if (this.googleApiClient == null) {
            Log.d((String)DonkyLocation.TAG, (String)"Initialising Location API.");
            return this.buildGoogleApiClient();
        }
        return this.googleApiClient;
    }

    private GoogleApiClient buildGoogleApiClient() {
        return new GoogleApiClient.Builder(this.context).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).addApi(LocationServices.API).build();
    }

    protected LocationRequest createLocationRequest() {
        LocationRequest locationRequest = new LocationRequest();
        locationRequest.setInterval(this.pollingProfile.getInterval());
        locationRequest.setFastestInterval(this.pollingProfile.getFastestInterval());
        locationRequest.setPriority(this.pollingProfile.getPriority());
        locationRequest.setSmallestDisplacement((float)this.pollingProfile.getSmallestDisplacement());
        return locationRequest;
    }

    public Location getLastLocation() {
        if (!this.checkLocationServicePermission()) {
            return null;
        }
        if (!this.getLocationAPI().isConnected() && !this.getLocationAPI().isConnecting()) {
            Log.d((String)DonkyLocation.TAG, (String)"connect API.");
            this.getLocationAPI().blockingConnect();
        }
        Log.d((String)DonkyLocation.TAG, (String)"FusedLocationApi.");
        return LocationServices.FusedLocationApi.getLastLocation(this.getLocationAPI());
    }

    public void registerLocationListener(LocationUpdatesCallback callback) {
        this.locationUpdateListeners.add(callback);
        if (!this.getLocationAPI().isConnected() && !this.getLocationAPI().isConnecting()) {
            this.getLocationAPI().connect();
            return;
        }
        Location location = this.getLastLocation();
        if (location != null) {
            this.onLocationChanged(location);
        }
    }

    public void registerLocationListener(LocationUpdatesCallback callback, LocationRequest locationRequest) {
        Pair pair = new Pair((Object)locationRequest, (Object)callback);
        this.customLocationUpdateListeners.add((Pair<LocationRequest, LocationUpdatesCallback>)pair);
        if (!this.getLocationAPI().isConnected() && !this.getLocationAPI().isConnecting()) {
            this.getLocationAPI().connect();
            return;
        }
        this.onLocationChanged(this.getLastLocation());
    }

    public void unregisterLocationListener(LocationUpdatesCallback callback) {
        if (!this.googleApiClient.isConnected()) {
            return;
        }
        if (this.locationUpdateListeners.contains(callback)) {
            this.locationUpdateListeners.remove(callback);
        } else if (this.customLocationUpdateListeners.contains(callback)) {
            this.customLocationUpdateListeners.remove(callback);
            LocationServices.FusedLocationApi.removeLocationUpdates(this.getLocationAPI(), (LocationListener)callback);
        }
        if (this.locationUpdateListeners.isEmpty() && this.customLocationUpdateListeners.isEmpty()) {
            LocationServices.FusedLocationApi.removeLocationUpdates(this.getLocationAPI(), (LocationListener)this);
        }
    }

    public void onConnected(Bundle bundle) {
        Log.d((String)DonkyLocation.TAG, (String)"Location services connected.");
        if (!this.checkLocationServicePermission()) {
            return;
        }
        LocationServices.FusedLocationApi.requestLocationUpdates(this.getLocationAPI(), this.createLocationRequest(), (LocationListener)this);
        for (LocationUpdatesCallback locationUpdatesCallback : this.locationUpdateListeners) {
            locationUpdatesCallback.onConnected(bundle);
        }
        for (Pair pair : this.customLocationUpdateListeners) {
            LocationServices.FusedLocationApi.requestLocationUpdates(this.getLocationAPI(), (LocationRequest)pair.first, (LocationListener)pair.second);
            ((LocationUpdatesCallback)pair.second).onConnected(bundle);
        }
        this.onLocationChanged(this.getLastLocation());
    }

    public void onConnectionSuspended(int i) {
        Log.d((String)DonkyLocation.TAG, (String)"onConnectionSuspended");
        if (i == 2) {
            Log.d((String)DonkyLocation.TAG, (String)"Location services suspended: connection lost");
        } else if (i == 1) {
            Log.d((String)DonkyLocation.TAG, (String)"Location services suspended: disconnected");
        } else {
            Log.d((String)DonkyLocation.TAG, (String)"Location services suspended.");
        }
        for (LocationUpdatesCallback locationUpdatesCallback : this.locationUpdateListeners) {
            locationUpdatesCallback.onConnectionSuspended(i);
        }
        for (Pair pair : this.customLocationUpdateListeners) {
            ((LocationUpdatesCallback)pair.second).onConnectionSuspended(i);
        }
    }

    public void onConnectionFailed(ConnectionResult connectionResult) {
        Log.d((String)DonkyLocation.TAG, (String)("Location services connection failed. " + connectionResult));
        for (LocationUpdatesCallback locationUpdatesCallback : this.locationUpdateListeners) {
            locationUpdatesCallback.onConnectionFailed(connectionResult);
        }
        for (Pair pair : this.customLocationUpdateListeners) {
            ((LocationUpdatesCallback)pair.second).onConnectionFailed(connectionResult);
        }
    }

    public void onLocationChanged(Location location) {
        if (location != null && this.locationUpdateListeners != null && !this.locationUpdateListeners.isEmpty()) {
            for (LocationUpdatesCallback callback : this.locationUpdateListeners) {
                callback.onLocationChanged(location);
            }
        }
    }

    public void requestUserLocation(TargetUser targetUser, DonkyListener donkyListener) {
        DonkyNetworkController.getInstance().sendClientNotification(LocationClientNotification.createRequestLocationNotification(targetUser.getExternalUserId(), targetUser.getNetworkProfileId(), targetUser.getDeviceId()), donkyListener);
    }

    public void sendLocationUpdate(DonkyListener donkyListener) {
        this.sendLocationUpdateToUser(null, donkyListener);
    }

    public void sendLocationUpdateToUser(final TargetUser targetUser, final DonkyListener donkyListener) {
        if (this.isLocationEnabled(this.context)) {
            this.registerLocationListener(new LocationUpdatesCallback(){

                public void onConnected(Bundle bundle) {
                }

                public void onLocationChanged(Location location) {
                    if (location != null) {
                        DonkyLocationController.this.unregisterLocationListener(this);
                        ClientNotification notification = targetUser != null ? LocationClientNotification.createLocationUpdateNotification(location.getLatitude(), location.getLongitude(), targetUser.getExternalUserId(), targetUser.getNetworkProfileId()) : LocationClientNotification.createLocationUpdateNotification(location.getLatitude(), location.getLongitude());
                        DonkyNetworkController.getInstance().sendClientNotification(notification, new DonkyListener(){

                            public void success() {
                                if (donkyListener != null) {
                                    donkyListener.success();
                                }
                            }

                            public void error(DonkyException donkyException, Map<String, String> validationErrors) {
                                if (donkyListener != null) {
                                    donkyListener.error(donkyException, validationErrors);
                                }
                            }
                        });
                    } else {
                        DonkyLocationController.this.log.debug("onLocationChanged with low accuracy. Waiting for better one.");
                    }
                }

                @Override
                public void onConnectionFailed(ConnectionResult connectionResult) {
                    super.onConnectionFailed(connectionResult);
                    DonkyLocationController.this.unregisterLocationListener(this);
                    if (donkyListener != null) {
                        donkyListener.error(new DonkyException("Location Manager Connection failed with result " + connectionResult.getErrorCode()), null);
                    }
                }

                @Override
                public void onConnectionSuspended(int cause) {
                    super.onConnectionSuspended(cause);
                    DonkyLocationController.this.unregisterLocationListener(this);
                    if (donkyListener != null) {
                        donkyListener.error(new DonkyException("Location Manager Connection suspended with cause " + cause), null);
                    }
                }
            });
        } else if (donkyListener != null) {
            donkyListener.error(new DonkyException("Location has not been enabled on the phone."), null);
        }
    }

    public static boolean checkGooglePlayServices(final Activity activity) {
        int googlePlayServicesCheck = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)activity);
        switch (googlePlayServicesCheck) {
            case 0: {
                return true;
            }
        }
        Dialog dialog = GooglePlayServicesUtil.getErrorDialog((int)googlePlayServicesCheck, (Activity)activity, (int)0);
        dialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialogInterface) {
                activity.finish();
            }
        });
        dialog.show();
        return false;
    }

    private boolean checkLocationServicePermission() {
        if (!this.isLocationEnabled(this.context)) {
            Log.e((String)DonkyLocation.TAG, (String)"Location Service is not available");
            return false;
        }
        return this.isPermissionGranted();
    }

    private boolean isPermissionGranted() {
        if (Build.VERSION.SDK_INT >= 23) {
            ArrayList<String> permissionsNeeded = new ArrayList<String>();
            ArrayList<String> permissionsList = new ArrayList<String>();
            if (!this.addPermission(permissionsList, "android.permission.ACCESS_FINE_LOCATION")) {
                permissionsNeeded.add("ACCESS_FINE_LOCATION");
            }
            if (!this.addPermission(permissionsList, "android.permission.ACCESS_COARSE_LOCATION")) {
                permissionsNeeded.add("ACCESS_COARSE_LOCATION");
            }
            if (permissionsList.size() > 0) {
                if (permissionsNeeded.size() > 0) {
                    for (String permission2 : permissionsNeeded) {
                        Log.w((String)DonkyLocation.TAG, (String)("You need to grant access to " + permission2));
                    }
                }
                return false;
            }
            return true;
        }
        return true;
    }

    @TargetApi(value=23)
    private boolean addPermission(List<String> permissionsList, String permission2) {
        if (this.context.checkSelfPermission(permission2) != 0) {
            permissionsList.add(permission2);
            return false;
        }
        return true;
    }

    private boolean isLocationEnabled(Context context) {
        int locationMode = 0;
        if (Build.VERSION.SDK_INT >= 19) {
            try {
                locationMode = Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)"location_mode");
            }
            catch (Settings.SettingNotFoundException e) {
                e.printStackTrace();
            }
            return locationMode != 0;
        }
        String locationProviders = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"location_providers_allowed");
        return !TextUtils.isEmpty((CharSequence)locationProviders);
    }

    public void appStopped() {
        if (this.locationUpdateListeners != null && this.locationUpdateListeners.size() > 0) {
            this.locationUpdateListeners.clear();
        }
        if (this.customLocationUpdateListeners != null && this.customLocationUpdateListeners.size() > 0) {
            this.customLocationUpdateListeners.clear();
        }
        if (this.googleApiClient != null && this.googleApiClient.isConnected()) {
            this.googleApiClient.disconnect();
        }
    }

    public boolean isShouldAutomaticallySendLocation() {
        return this.shouldAutomaticallySendLocation;
    }

    public void setShouldAutomaticallySendLocation(boolean shouldAutomaticallySendLocation) {
        this.shouldAutomaticallySendLocation = shouldAutomaticallySendLocation;
    }

    void startAutomaticLocationUpdatesTimer() {
        if (this.timer != null) {
            this.timer.startTimer();
        }
    }

    void stopAutomaticLocationUpdatesTimer() {
        if (this.timer != null) {
            this.timer.stopTimer();
        }
    }

    private static class SingletonHolder {
        private static final DonkyLocationController INSTANCE = new DonkyLocationController();

        private SingletonHolder() {
        }
    }
}

