/*
 * Decompiled with CFR 0.152.
 */
package net.donky.location;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.LinkedList;
import java.util.List;
import net.donky.core.DonkyCore;
import net.donky.core.events.LocalEvent;
import net.donky.core.network.ServerNotification;
import net.donky.core.network.location.UserLocation;
import net.donky.core.network.location.UserLocationRequest;
import net.donky.location.DonkyLocationController;
import net.donky.location.TargetUser;
import net.donky.location.events.LocationRequestedEvent;
import net.donky.location.events.UserLocationEvent;

public class NotificationHandler {
    NotificationHandler() {
    }

    void handleLocationRequest(List<ServerNotification> serverNotifications) {
        LinkedList<UserLocationRequest> requests = new LinkedList<UserLocationRequest>();
        boolean shouldAutomaticallySendLocation = DonkyLocationController.getInstance().isShouldAutomaticallySendLocation();
        for (ServerNotification serverNotification : serverNotifications) {
            JsonObject data;
            Gson gson;
            UserLocationRequest request;
            if (!"LocationRequest".equals(serverNotification.getType()) || (request = (UserLocationRequest)(gson = new Gson()).fromJson((data = serverNotification.getData()).toString(), UserLocationRequest.class)) == null) continue;
            requests.add(request);
            if (!shouldAutomaticallySendLocation) continue;
            DonkyLocationController.getInstance().sendLocationUpdateToUser(TargetUser.getTargetUserByProfileId(request.getSendToNetworkProfileId()), null);
        }
        DonkyCore.publishLocalEvent((LocalEvent)new LocationRequestedEvent(requests));
    }

    void handleUserLocation(List<ServerNotification> serverNotifications) {
        LinkedList<UserLocation> locations = new LinkedList<UserLocation>();
        for (ServerNotification serverNotification : serverNotifications) {
            JsonObject data;
            Gson gson;
            UserLocation location;
            if (!"UserLocation".equals(serverNotification.getType()) || (location = (UserLocation)(gson = new Gson()).fromJson((data = serverNotification.getData()).toString(), UserLocation.class)) == null) continue;
            locations.add(location);
        }
        DonkyCore.publishLocalEvent((LocalEvent)new UserLocationEvent(locations));
    }
}

