/*
 * Decompiled with CFR 0.152.
 */
package net.donky.location.internal;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import net.donky.core.helpers.DateAndTimeHelper;
import net.donky.core.helpers.IdHelper;
import net.donky.core.network.ClientNotification;
import net.donky.core.network.location.LocationPoint;
import org.json.JSONException;
import org.json.JSONObject;

public class LocationClientNotification
extends ClientNotification {
    protected LocationClientNotification(String type, String id) {
        super(type, id);
    }

    public static ClientNotification createRequestLocationNotification(String externalUserId, String networkProfileId, String deviceId) {
        LocationClientNotification n = new LocationClientNotification(LocationNotificationType.RequestLocation.toString(), IdHelper.generateId());
        Gson gson = new Gson();
        try {
            n.data = deviceId != null ? new JSONObject(gson.toJson((Object)LocationClientNotification.createLocationRequest(externalUserId, networkProfileId, deviceId))) : new JSONObject(gson.toJson((Object)LocationClientNotification.createLocationRequest(externalUserId, networkProfileId)));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return n;
    }

    public static ClientNotification createLocationUpdateNotification(double latitude, double longitude) {
        LocationClientNotification n = new LocationClientNotification(LocationNotificationType.LocationUpdate.toString(), IdHelper.generateId());
        Gson gson = new Gson();
        try {
            n.data = new JSONObject(gson.toJson((Object)LocationClientNotification.createLocationUpdate(latitude, longitude)));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return n;
    }

    public static ClientNotification createLocationUpdateNotification(double latitude, double longitude, String externalUserId, String networkProfileId) {
        LocationClientNotification n = new LocationClientNotification(LocationNotificationType.LocationUpdate.toString(), IdHelper.generateId());
        Gson gson = new Gson();
        try {
            n.data = new JSONObject(gson.toJson((Object)LocationClientNotification.createLocationUpdate(latitude, longitude, externalUserId, networkProfileId)));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return n;
    }

    private static RequestLocation createLocationRequest(String externalUserId, String networkProfileId) {
        RequestLocation requestLocation = new RequestLocation();
        requestLocation.targetUser = new TargetUser(externalUserId, networkProfileId);
        requestLocation.type = LocationNotificationType.RequestLocation.toString();
        return requestLocation;
    }

    private static RequestLocation createLocationRequest(String externalUserId, String networkProfileId, String targetDeviceId) {
        RequestLocation requestLocation = new RequestLocation();
        requestLocation.type = LocationNotificationType.RequestLocation.toString();
        requestLocation.targetUser = new TargetUser(externalUserId, networkProfileId);
        requestLocation.targetDeviceId = targetDeviceId;
        return requestLocation;
    }

    private static LocationUpdate createLocationUpdate(double latitude, double longitude, String externalId, String networkProfileId) {
        LocationUpdate locationUpdate = new LocationUpdate();
        locationUpdate.type = LocationNotificationType.LocationUpdate.toString();
        locationUpdate.location = new LocationPoint(latitude, longitude);
        locationUpdate.notifyUser = new TargetUser(externalId, networkProfileId);
        locationUpdate.timestamp = DateAndTimeHelper.getCurrentUTCTime();
        return locationUpdate;
    }

    private static LocationUpdate createLocationUpdate(double latitude, double longitude) {
        LocationUpdate locationUpdate = new LocationUpdate();
        locationUpdate.type = LocationNotificationType.LocationUpdate.toString();
        locationUpdate.location = new LocationPoint(latitude, longitude);
        locationUpdate.timestamp = DateAndTimeHelper.getCurrentUTCTime();
        return locationUpdate;
    }

    private static class RequestLocation {
        @SerializedName(value="type")
        private String type;
        @SerializedName(value="targetUser")
        private TargetUser targetUser;
        @SerializedName(value="targetDeviceId")
        private String targetDeviceId;

        private RequestLocation() {
        }
    }

    private static class TargetUser {
        @SerializedName(value="userId")
        private String userId;
        @SerializedName(value="networkProfileId")
        private String networkProfileId;

        public TargetUser(String userId, String networkProfileId) {
            this.userId = userId;
            this.networkProfileId = networkProfileId;
        }
    }

    private static class LocationUpdate {
        @SerializedName(value="type")
        private String type;
        @SerializedName(value="notifyUser")
        private TargetUser notifyUser;
        @SerializedName(value="location")
        private LocationPoint location;
        @SerializedName(value="timestamp")
        private String timestamp;

        private LocationUpdate() {
        }
    }

    public static enum LocationNotificationType {
        RequestLocation,
        LocationUpdate;

    }
}

