/*
 * Decompiled with CFR 0.152.
 */
package net.donky.location.internal;

import android.content.Context;
import android.os.CountDownTimer;
import java.util.Map;
import net.donky.core.DonkyException;
import net.donky.core.DonkyListener;
import net.donky.core.logging.DLog;
import net.donky.core.model.DonkyDataController;
import net.donky.location.DonkyLocationController;

public class LocationUpdateTimer {
    private final int defaultInterval = 300000;
    Context context;
    long delayInMilliseconds;
    DLog log;
    CountDownTimer countDownTimer;
    private long MILLIS_IN_FUTURE = Long.MAX_VALUE;

    public LocationUpdateTimer(Context context) {
        this.log = new DLog("LocationUpdateTimer");
        this.context = context;
    }

    public void startTimer() {
        try {
            Integer delay;
            String interval = (String)DonkyDataController.getInstance().getConfigurationDAO().getConfigurationItems().get("LocationUpdateIntervalSeconds");
            this.delayInMilliseconds = interval != null ? ((delay = Integer.valueOf(Integer.parseInt(interval))) != null && delay > 0 ? (long)(delay * 1000) : 300000L) : 300000L;
        }
        catch (Exception e) {
            this.delayInMilliseconds = 300000L;
            this.log.error("Error setting delay for location updates.", e);
        }
        if (this.countDownTimer == null) {
            this.countDownTimer = new CountDownTimer(this.MILLIS_IN_FUTURE, this.delayInMilliseconds){

                public void onTick(long millisUntilFinished) {
                    LocationUpdateTimer.this.performTickAction();
                }

                public void onFinish() {
                    LocationUpdateTimer.this.log.debug("CountDownTimer finished.");
                }
            };
        }
        this.countDownTimer.start();
    }

    public void stopTimer() {
        if (this.countDownTimer != null) {
            this.countDownTimer.cancel();
            this.countDownTimer = null;
        }
    }

    public void setDelayInMilliseconds(long delayInMilliseconds) {
        this.delayInMilliseconds = delayInMilliseconds;
    }

    private void performTickAction() {
        DonkyLocationController.getInstance().sendLocationUpdate(new DonkyListener(){

            public void success() {
            }

            public void error(DonkyException donkyException, Map<String, String> validationErrors) {
                LocationUpdateTimer.this.log.warning("Couldn't send automatic location update.");
            }
        });
    }
}

