/*
 * Decompiled with CFR 0.152.
 */
package net.donky.core.messaging.push;

import android.app.Application;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Build;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.donky.core.DonkyCore;
import net.donky.core.DonkyException;
import net.donky.core.DonkyListener;
import net.donky.core.ModuleDefinition;
import net.donky.core.NotificationBatchListener;
import net.donky.core.Subscription;
import net.donky.core.assets.DonkyAssets;
import net.donky.core.fcm.DonkyFcmController;
import net.donky.core.messaging.logic.DonkyMessaging;
import net.donky.core.messaging.push.logic.PushLogicController;
import net.donky.core.messaging.push.logic.SimplePushHandler;
import net.donky.core.messaging.push.ui.SimplePushUIConfiguration;
import net.donky.core.network.ServerNotification;

public class DonkyPush {
    private final String version = "2.0.0.3";
    public static final String PLATFORM = "Mobile";
    private static final AtomicBoolean initialised = new AtomicBoolean(false);
    private Context context;
    private SimplePushUIConfiguration simplePushUIConfiguration;

    private DonkyPush() {
    }

    public static DonkyPush getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public static void initialiseDonkyPush(Application application, boolean shouldDisplayRemoteNotifications, DonkyListener donkyListener) {
        DonkyPush.getInstance().init(application, shouldDisplayRemoteNotifications, donkyListener, null);
    }

    public static void initialiseDonkyPush(Application application, boolean shouldDisplayRemoteNotifications, DonkyListener donkyListener, SimplePushUIConfiguration config) {
        DonkyPush.getInstance().init(application, shouldDisplayRemoteNotifications, donkyListener, config);
    }

    private void init(final Application application, final boolean shouldDisplayRemoteNotifications, final DonkyListener donkyListener, SimplePushUIConfiguration config) {
        if (!initialised.get()) {
            this.context = application.getApplicationContext();
            try {
                if (shouldDisplayRemoteNotifications) {
                    if (config == null) {
                        this.simplePushUIConfiguration = new SimplePushUIConfiguration(this.context);
                        this.createPushChannel(this.simplePushUIConfiguration);
                    } else {
                        this.setSimplePushUIConfiguration(config);
                        this.createPushChannel(config);
                    }
                }
                DonkyCore.registerModule((ModuleDefinition)new ModuleDefinition(DonkyPush.class.getSimpleName(), "2.0.0.3"));
                DonkyMessaging.initialiseDonkyMessaging((Application)application, (DonkyListener)new DonkyListener(){

                    public void success() {
                        DonkyAssets.initialiseDonkyAssets((Application)application, (DonkyListener)new DonkyListener(){

                            public void success() {
                                PushLogicController.getInstance().init(application);
                                LinkedList<Subscription> serverNotificationSubscriptions = new LinkedList<Subscription>();
                                serverNotificationSubscriptions.add(new Subscription("SimplePushMessage", (NotificationBatchListener)new NotificationBatchListener<ServerNotification>(){

                                    public void onNotification(ServerNotification notification) {
                                    }

                                    public void onNotification(List<ServerNotification> notifications) {
                                        new SimplePushHandler().handleSimplePushMessage(DonkyPush.this.context, shouldDisplayRemoteNotifications, DonkyPush.this.simplePushUIConfiguration, notifications);
                                    }
                                }));
                                DonkyCore.subscribeToDonkyNotifications((ModuleDefinition)new ModuleDefinition(DonkyPush.class.getSimpleName(), "2.0.0.3"), serverNotificationSubscriptions, (boolean)false);
                                initialised.set(true);
                                if (donkyListener != null) {
                                    donkyListener.success();
                                }
                            }

                            public void error(DonkyException donkyException, Map<String, String> validationErrors) {
                                if (donkyListener != null) {
                                    donkyListener.error(donkyException, validationErrors);
                                }
                            }
                        });
                    }

                    public void error(DonkyException donkyException, Map<String, String> validationErrors) {
                        if (donkyListener != null) {
                            donkyListener.error(donkyException, null);
                        }
                    }
                });
            }
            catch (Exception e) {
                DonkyException donkyException = new DonkyException("Error initialising Automation Module");
                donkyException.initCause((Throwable)e);
                if (donkyListener != null) {
                    donkyListener.error(donkyException, null);
                }
            }
        } else if (donkyListener != null) {
            donkyListener.success();
        }
    }

    public static boolean isInitialised() {
        return initialised.get();
    }

    public SimplePushUIConfiguration getSimplePushUIConfiguration() {
        return this.simplePushUIConfiguration;
    }

    public void setSimplePushUIConfiguration(SimplePushUIConfiguration simplePushUIConfiguration) {
        this.simplePushUIConfiguration = simplePushUIConfiguration;
    }

    private void createPushChannel(SimplePushUIConfiguration config) {
        NotificationManager notificationManager;
        if (Build.VERSION.SDK_INT >= 26 && (notificationManager = (NotificationManager)this.context.getSystemService("notification")) != null) {
            String name = config.getPushChannelName();
            String description = config.getPushChannelDescription();
            int importance = config.getPushChannelImportance();
            if (importance < 0 || importance > 4) {
                importance = 4;
            }
            NotificationChannel channel = new NotificationChannel(DonkyFcmController.getPushChannelId((Context)this.context), (CharSequence)name, importance);
            channel.setDescription(description);
            channel.enableLights(true);
            channel.setLightColor(config.getLedColour());
            channel.enableVibration(true);
            channel.setVibrationPattern(config.getVibratePattern());
            notificationManager.createNotificationChannel(channel);
        }
    }

    private static class SingletonHolder {
        private static final DonkyPush INSTANCE = new DonkyPush();

        private SingletonHolder() {
        }
    }
}

