/*
 * Decompiled with CFR 0.152.
 */
package net.donky.core.messaging.push.logic;

import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.util.Date;
import java.util.Map;
import net.donky.core.helpers.DateAndTimeHelper;
import net.donky.core.helpers.IdHelper;
import net.donky.core.messaging.push.logic.SimplePushData;
import org.json.JSONException;
import org.json.JSONObject;

public class ClientNotification
extends net.donky.core.network.ClientNotification {
    protected ClientNotification(String type, String id) {
        super(type, id);
    }

    static net.donky.core.network.ClientNotification createInteractionResultNotification(SimplePushData.ButtonSetAction buttonSetAction, SimplePushData simplePushData) {
        ClientNotification n = new ClientNotification(Type.InteractionResult.toString(), IdHelper.generateId());
        Gson gson = new Gson();
        try {
            n.data = new JSONObject(gson.toJson((Object)ClientNotification.createInteractionResult(n, buttonSetAction, simplePushData)));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return n;
    }

    private static InteractionResult createInteractionResult(ClientNotification n, SimplePushData.ButtonSetAction buttonSetAction, SimplePushData simplePushData) {
        ClientNotification clientNotification = n;
        ((Object)((Object)clientNotification)).getClass();
        InteractionResult u = clientNotification.new InteractionResult();
        u.type = Type.InteractionResult.toString();
        u.operatingSystem = "Android";
        if (simplePushData != null) {
            u.senderInternalUserId = simplePushData.getSenderInternalUserId();
            u.messageId = simplePushData.getMessageId();
            u.senderMessageId = simplePushData.getSenderMessageId();
            u.interactionTimeStamp = DateAndTimeHelper.getCurrentUTCTime();
            u.messageSentTimestamp = simplePushData.getSentTimestamp();
            u.contextItems = simplePushData.getContextItems();
            u.timeToInteractionSeconds = (new Date().getTime() - DateAndTimeHelper.parseUtcDate((String)simplePushData.getSentTimestamp()).getTime()) / 1000L;
            if (simplePushData.getButtonSets() != null) {
                SimplePushData.ButtonSet buttonSetToUse = null;
                for (SimplePushData.ButtonSet buttonSet : simplePushData.getButtonSets()) {
                    if (buttonSet == null || !"Mobile".equals(buttonSet.getPlatform())) continue;
                    buttonSetToUse = buttonSet;
                }
                if (buttonSetToUse != null) {
                    u.interactionType = buttonSetToUse.getInteractionType();
                    if (buttonSetToUse.getButtonSetActions() != null) {
                        if (buttonSetToUse.getButtonSetActions().length == 1) {
                            u.buttonDescription = buttonSetToUse.getButtonSetActions()[0].getLabel();
                            u.userAction = "Button1";
                        } else if (buttonSetToUse.getButtonSetActions().length == 2) {
                            StringBuilder sb = new StringBuilder();
                            sb.append(buttonSetToUse.getButtonSetActions()[0].getLabel());
                            sb.append("|");
                            sb.append(buttonSetToUse.getButtonSetActions()[1].getLabel());
                            u.buttonDescription = sb.toString();
                            u.userAction = TextUtils.equals((CharSequence)buttonSetAction.getLabel(), (CharSequence)buttonSetToUse.getButtonSetActions()[0].getLabel()) ? "Button1" : "Button2";
                        }
                    }
                }
            }
        }
        return u;
    }

    private class InteractionResult {
        @SerializedName(value="type")
        private String type;
        @SerializedName(value="senderInternalUserId")
        private String senderInternalUserId;
        @SerializedName(value="messageId")
        private String messageId;
        @SerializedName(value="senderMessageId")
        private String senderMessageId;
        @SerializedName(value="timeToInteractionSeconds")
        private long timeToInteractionSeconds;
        @SerializedName(value="interactionTimeStamp")
        private String interactionTimeStamp;
        @SerializedName(value="interactionType")
        private String interactionType;
        @SerializedName(value="buttonDescription")
        private String buttonDescription;
        @SerializedName(value="userAction")
        private String userAction;
        @SerializedName(value="operatingSystem")
        private String operatingSystem;
        @SerializedName(value="messageSentTimestamp")
        private String messageSentTimestamp;
        @SerializedName(value="contextItems")
        private Map<String, String> contextItems;

        private InteractionResult() {
        }
    }

    static enum Type {
        InteractionResult;

    }
}

