/*
 * Decompiled with CFR 0.152.
 */
package net.donky.core.messaging.push.logic;

import android.app.Application;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import java.io.Serializable;
import java.util.Random;
import net.donky.core.messaging.push.DonkyPush;
import net.donky.core.messaging.push.logic.ClientNotification;
import net.donky.core.messaging.push.logic.PushLogicIntentService;
import net.donky.core.messaging.push.logic.SimplePushData;
import net.donky.core.network.DonkyNetworkController;

public class PushLogicController {
    private static final String ACTION_TYPE_OPEN = "Open";
    private static final String ACTION_TYPE_DEEP_LINK = "DeepLink";
    private static final String ACTION_TYPE_DISMISS = "Dismiss";
    static final String EXTRAS_KEY_NOTIFICATION_ID = "AndroidSystemNotificationId";
    private Context context;

    private PushLogicController() {
    }

    public static PushLogicController getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void init(Application application) {
        this.context = application.getApplicationContext();
    }

    public PendingIntent createPendingIntent(SimplePushData.ButtonSetAction buttonSetAction, SimplePushData simplePushData, int notificationId) {
        if (DonkyPush.isInitialised()) {
            Intent intent = new Intent(this.context, PushLogicIntentService.class);
            if (Build.VERSION.SDK_INT >= 12) {
                intent.addFlags(32);
            }
            intent.putExtra(EXTRAS_KEY_NOTIFICATION_ID, notificationId);
            intent.putExtras(this.getReportingDataBundle(buttonSetAction, simplePushData));
            Integer pendingIntentId = Math.abs(new Random().nextInt(Integer.MAX_VALUE));
            if (buttonSetAction != null) {
                if (ACTION_TYPE_OPEN.equals(buttonSetAction.getActionType())) {
                    intent.setAction("net.donky.core.messaging.push.OPEN");
                } else if (ACTION_TYPE_DEEP_LINK.equals(buttonSetAction.getActionType())) {
                    intent.setAction("net.donky.core.messaging.push.DEEP_LINK");
                } else if (ACTION_TYPE_DISMISS.equals(buttonSetAction.getActionType())) {
                    intent.setAction("net.donky.core.messaging.push.CANCEL_NOTIFICATION");
                }
                return PendingIntent.getService((Context)this.context, (int)pendingIntentId, (Intent)intent, (int)0x8000000);
            }
            String packageName = this.context.getApplicationContext().getPackageName();
            PackageManager pm = this.context.getPackageManager();
            Intent newIntent = pm.getLaunchIntentForPackage(packageName);
            if (newIntent != null) {
                if (Build.VERSION.SDK_INT >= 12) {
                    newIntent.addFlags(32);
                }
                newIntent.putExtra("isOpenedFromNotification", true);
                return PendingIntent.getActivity((Context)this.context, (int)notificationId, (Intent)newIntent, (int)0x8000000);
            }
            return null;
        }
        return null;
    }

    protected Bundle getReportingDataBundle(SimplePushData.ButtonSetAction buttonSetAction, SimplePushData simplePushData) {
        Bundle bundle = new Bundle();
        bundle.putSerializable("simplePushData", (Serializable)simplePushData);
        bundle.putSerializable("buttonSetAction", (Serializable)buttonSetAction);
        return bundle;
    }

    public void reportPushNotificationClicked(Intent intent) {
        Bundle bundle = intent.getExtras();
        SimplePushData simplePushData = (SimplePushData)bundle.getSerializable("simplePushData");
        SimplePushData.ButtonSetAction buttonSetAction = (SimplePushData.ButtonSetAction)bundle.getSerializable("buttonSetAction");
        DonkyNetworkController.getInstance().sendClientNotification(ClientNotification.createInteractionResultNotification(buttonSetAction, simplePushData), null);
    }

    private static class SingletonHolder {
        private static final PushLogicController INSTANCE = new PushLogicController();

        private SingletonHolder() {
        }
    }
}

