/*
 * Decompiled with CFR 0.152.
 */
package net.donky.core.messaging.push.logic;

import android.app.IntentService;
import android.app.NotificationManager;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import java.io.Serializable;
import java.util.List;
import net.donky.core.logging.DLog;
import net.donky.core.messaging.push.logic.PushLogicController;
import net.donky.core.messaging.push.logic.SimplePushData;

public class PushLogicIntentService
extends IntentService {
    static final String ACTION_CANCEL_NOTIFICATION = "net.donky.core.messaging.push.CANCEL_NOTIFICATION";
    static final String ACTION_OPEN_APPLICATION = "net.donky.core.messaging.push.OPEN";
    static final String ACTION_OPEN_DEEP_LINK = "net.donky.core.messaging.push.DEEP_LINK";
    private DLog log = new DLog("PushLogicIntentService");

    public PushLogicIntentService() {
        super("PushLogicIntentService");
    }

    protected void onHandleIntent(Intent intent) {
        if (ACTION_CANCEL_NOTIFICATION.equals(intent.getAction())) {
            this.cancelNotification(intent);
            PushLogicController.getInstance().reportPushNotificationClicked(intent);
        } else if (ACTION_OPEN_DEEP_LINK.equals(intent.getAction())) {
            this.cancelNotification(intent);
            PushLogicController.getInstance().reportPushNotificationClicked(intent);
            Intent newIntent = new Intent();
            this.setDonkyDataBundle(intent, newIntent);
            newIntent.putExtra("isOpenedFromNotification", true);
            newIntent.setAction("android.intent.action.VIEW");
            newIntent.addCategory("android.intent.category.DEFAULT");
            newIntent.addFlags(0x10000000);
            if (this.isActivityAvailable(newIntent)) {
                this.startActivity(newIntent);
            }
        } else if (ACTION_OPEN_APPLICATION.equals(intent.getAction())) {
            this.cancelNotification(intent);
            PushLogicController.getInstance().reportPushNotificationClicked(intent);
            String packageName = this.getApplicationContext().getApplicationContext().getPackageName();
            PackageManager pm = this.getApplicationContext().getPackageManager();
            Intent newIntent = pm.getLaunchIntentForPackage(packageName);
            this.setDonkyDataBundle(intent, newIntent);
            newIntent.putExtra("isOpenedFromNotification", true);
            newIntent.setAction("android.intent.action.VIEW");
            newIntent.addCategory("android.intent.category.DEFAULT");
            newIntent.addFlags(0x10000000);
            this.startActivity(newIntent);
        }
    }

    private void cancelNotification(Intent intent) {
        if (intent.getExtras().containsKey("AndroidSystemNotificationId")) {
            int notificationId = intent.getIntExtra("AndroidSystemNotificationId", 0);
            NotificationManager manager = (NotificationManager)this.getApplicationContext().getSystemService("notification");
            if (manager != null && notificationId != 0) {
                manager.cancel(notificationId);
            }
        } else {
            this.log.error("Missing notification id for dismiss action.");
        }
    }

    private void setDonkyDataBundle(Intent oldIntent, Intent intent) {
        Bundle bundle = new Bundle();
        try {
            SimplePushData simplePushData = (SimplePushData)oldIntent.getExtras().getSerializable("simplePushData");
            SimplePushData.ButtonSetAction buttonSetAction = (SimplePushData.ButtonSetAction)oldIntent.getExtras().getSerializable("buttonSetAction");
            if (buttonSetAction != null && !TextUtils.isEmpty((CharSequence)buttonSetAction.getData())) {
                intent.setData(Uri.parse((String)buttonSetAction.getData()));
                if (buttonSetAction.getData().startsWith("http") || buttonSetAction.getData().startsWith("https")) {
                    return;
                }
            }
            bundle.putSerializable("simplePushData", (Serializable)simplePushData);
            bundle.putSerializable("buttonSetAction", (Serializable)buttonSetAction);
        }
        catch (Exception e) {
            this.log.error("Error transmitting data between intents.", e);
        }
        intent.putExtras(bundle);
    }

    public boolean isActivityAvailable(Intent intent) {
        PackageManager mgr = this.getApplicationContext().getPackageManager();
        List list = mgr.queryIntentActivities(intent, 65536);
        return list.size() > 0;
    }
}

