/*
 * Decompiled with CFR 0.152.
 */
package net.donky.core.messaging.push.logic;

import android.content.Context;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import net.donky.core.DonkyCore;
import net.donky.core.events.LocalEvent;
import net.donky.core.helpers.DateAndTimeHelper;
import net.donky.core.lifecycle.LifeCycleObserver;
import net.donky.core.messaging.logic.MessagingInternalController;
import net.donky.core.messaging.logic.model.MessageReceivedDetails;
import net.donky.core.messaging.push.logic.SimplePushData;
import net.donky.core.messaging.push.logic.events.SimplePushMessageEvent;
import net.donky.core.messaging.push.ui.EventHandler;
import net.donky.core.messaging.push.ui.SimplePushUIConfiguration;
import net.donky.core.network.AcknowledgementDetail;
import net.donky.core.network.DonkyNetworkController;
import net.donky.core.network.ServerNotification;

public class SimplePushHandler {
    public void handleSimplePushMessage(Context context, boolean shouldDisplayRemoteNotifications, SimplePushUIConfiguration simplePushUIConfiguration, List<ServerNotification> serverNotifications) {
        LinkedList<SimplePushData> simplePushDataList = new LinkedList<SimplePushData>();
        for (ServerNotification serverNotification : serverNotifications) {
            if (!"SimplePushMessage".equals(serverNotification.getType())) continue;
            JsonObject data = serverNotification.getData();
            Gson gson = new Gson();
            SimplePushData simplePushData = (SimplePushData)gson.fromJson(data.toString(), SimplePushData.class);
            MessageReceivedDetails messageReceivedDetails = new MessageReceivedDetails();
            messageReceivedDetails.setMessageType(simplePushData.getMessageType());
            messageReceivedDetails.setMessageId(simplePushData.getMessageId());
            messageReceivedDetails.setMessageScope(MessageReceivedDetails.MessageScope.A2P.toString());
            messageReceivedDetails.setContextItems(simplePushData.getContextItems());
            messageReceivedDetails.setSenderInternalUserId(simplePushData.getSenderInternalUserId());
            messageReceivedDetails.setSenderMessageId(simplePushData.getSenderMessageId());
            messageReceivedDetails.setSentTimestamp(simplePushData.getSentTimestamp());
            Date expiredTime = DateAndTimeHelper.parseUtcDate((String)simplePushData.getExpiryTimeStamp());
            boolean receivedExpired = false;
            if (expiredTime != null) {
                receivedExpired = expiredTime.before(new Date());
                if (receivedExpired) {
                    messageReceivedDetails.setReceivedExpired(true);
                } else {
                    messageReceivedDetails.setReceivedExpired(false);
                }
            }
            AcknowledgementDetail acknowledgementDetail = new AcknowledgementDetail();
            acknowledgementDetail.setCustomNotificationType(null);
            acknowledgementDetail.setType(serverNotification.getType());
            acknowledgementDetail.setResult(AcknowledgementDetail.Result.Delivered.toString());
            acknowledgementDetail.setSentTime(serverNotification.getCreatedOn());
            acknowledgementDetail.setServerNotificationId(serverNotification.getId());
            messageReceivedDetails.setAcknowledgementDetail(acknowledgementDetail);
            MessagingInternalController.getInstance().queueMessageReceivedNotification(messageReceivedDetails);
            simplePushData.setReceivedExpired(receivedExpired);
            simplePushDataList.add(simplePushData);
        }
        if (LifeCycleObserver.getInstance().isApplicationForegrounded()) {
            DonkyNetworkController.getInstance().synchronise();
        }
        SimplePushMessageEvent event = new SimplePushMessageEvent(simplePushDataList);
        DonkyCore.publishLocalEvent((LocalEvent)event);
        if (shouldDisplayRemoteNotifications) {
            new EventHandler().handleSimplePushEvent(context, event, simplePushUIConfiguration);
        }
    }
}

