/*
 * Decompiled with CFR 0.152.
 */
package net.donky.core.messaging.push.ui;

import android.app.Notification;
import android.app.NotificationManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import net.donky.core.DonkyCore;
import net.donky.core.assets.DonkyAssetController;
import net.donky.core.assets.NotificationImageLoader;
import net.donky.core.logging.DLog;
import net.donky.core.messaging.push.logic.SimplePushData;
import net.donky.core.messaging.push.logic.events.SimplePushMessageEvent;
import net.donky.core.messaging.push.ui.SimplePushUIConfiguration;
import net.donky.core.messaging.push.ui.SystemNotificationBuilder;

public class EventHandler {
    public void handleSimplePushEvent(Context context, SimplePushMessageEvent event, SimplePushUIConfiguration simplePushUIConfiguration) {
        if (event != null) {
            if (!DonkyCore.getInstance().isModuleRegistered("DonkyCore", "2.0.0.3")) {
                new DLog("PushUIEventHandler").error("Donky Core minimal version 2.0.0.3 required.");
            } else {
                for (SimplePushData simplePushData : event.getBatchSimplePushData()) {
                    if (simplePushData.isReceivedExpired()) continue;
                    this.displayNotification(context, simplePushUIConfiguration, simplePushData);
                }
            }
        }
    }

    public void displayNotification(final Context context, final SimplePushUIConfiguration simplePushUIConfiguration, final SimplePushData simplePushData) {
        if (simplePushData != null && !TextUtils.isEmpty((CharSequence)simplePushData.getAvatarAssetId())) {
            DonkyAssetController.getInstance().downloadImageAsset(simplePushData.getAvatarAssetId(), new NotificationImageLoader(context){

                public void success(Bitmap bitmap) {
                    EventHandler.this.displayNotification(context, simplePushData, simplePushUIConfiguration, bitmap);
                }

                public void failure(Exception e) {
                    EventHandler.this.displayNotification(context, simplePushData, simplePushUIConfiguration, null);
                }
            });
        } else {
            this.displayNotification(context, simplePushData, simplePushUIConfiguration, null);
        }
    }

    private void displayNotification(Context context, SimplePushData data, SimplePushUIConfiguration simplePushUIConfiguration, Bitmap avatar) {
        int id = data.getMessageId().hashCode();
        Notification notification = new SystemNotificationBuilder(id).buildSimplePushUINotification(context, simplePushUIConfiguration, data, avatar);
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        notificationManager.notify(id, notification);
    }
}

