/*
 * Decompiled with CFR 0.152.
 */
package net.donky.core.messaging.push.ui;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.TypedArray;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import net.donky.core.logging.DLog;
import net.donky.core.messaging.push.R;

public class SimplePushUIConfiguration {
    private int ledColour;
    private int ledOnMilliseconds;
    private int ledOffMilliseconds;
    private PendingIntent contentIntent;
    private Uri soundUri;
    private long[] vibratePattern;
    private String category;
    private int priority;
    private int visibility;
    private int iconBackgroundColor;
    private int[] actionButtonIconIds;
    private PendingIntent[] pendingIntents;
    private int smallIconId;
    private String pushChannelName;
    private String pushChannelDescription;
    private int pushChannelImportance;

    @SuppressLint(value={"NewApi"})
    public SimplePushUIConfiguration(Context context) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.category = "msg";
            this.priority = 1;
            this.visibility = 1;
        }
        this.vibratePattern = new long[]{0L, 100L};
        this.soundUri = RingtoneManager.getDefaultUri((int)2);
        this.iconBackgroundColor = R.color.donky_notification_icon_background;
        this.ledOnMilliseconds = 200;
        this.ledOffMilliseconds = 2000;
        this.ledColour = R.color.donky_notification_led;
        this.actionButtonIconIds = new int[]{17170445, 17170445};
        this.pendingIntents = new PendingIntent[]{null, null};
        int attributeResourceId = -1;
        try {
            String packageName = context.getApplicationContext().getPackageName();
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(packageName, 128);
            int theme = packageInfo.applicationInfo.theme;
            int[] attribute = new int[]{R.attr.dk_notification_small_icon_simple_push};
            TypedArray array = context.getTheme().obtainStyledAttributes(theme, attribute);
            attributeResourceId = array.getResourceId(0, -1);
            array.recycle();
        }
        catch (PackageManager.NameNotFoundException e) {
            new DLog("SimplePushUIConfiguration").error("Error getting styled notification icon", (Exception)((Object)e));
        }
        this.smallIconId = attributeResourceId != -1 ? attributeResourceId : R.drawable.donky_notification_small_icon_simple_push;
        this.pushChannelName = "Push notifications";
        this.pushChannelDescription = "Text notifications for the app";
        this.pushChannelImportance = 4;
    }

    public int getSmallIconId() {
        return this.smallIconId;
    }

    public Uri getSoundUri() {
        return this.soundUri;
    }

    public void setSoundUri(Uri soundUri) {
        this.soundUri = soundUri;
    }

    public long[] getVibratePattern() {
        return this.vibratePattern;
    }

    public void setVibratePattern(long[] vibratePattern) {
        this.vibratePattern = vibratePattern;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getVisibility() {
        return this.visibility;
    }

    public void setVisibility(int visibility) {
        this.visibility = visibility;
    }

    public int getIconBackgroundColor() {
        return this.iconBackgroundColor;
    }

    public void setIconBackgroundColor(int iconBackgroundColor) {
        this.iconBackgroundColor = iconBackgroundColor;
    }

    public int getLedColour() {
        return this.ledColour;
    }

    public int getLedOnMilliseconds() {
        return this.ledOnMilliseconds;
    }

    public int getLedOffMilliseconds() {
        return this.ledOffMilliseconds;
    }

    public void setLedColour(int ledColour) {
        this.ledColour = ledColour;
    }

    public void setLedOnMilliseconds(int ledOnMilliseconds) {
        this.ledOnMilliseconds = ledOnMilliseconds;
    }

    public void setLedOffMilliseconds(int ledOffMilliseconds) {
        this.ledOffMilliseconds = ledOffMilliseconds;
    }

    public int[] getActionButtonIconIds() {
        return this.actionButtonIconIds;
    }

    public void setActionButtonIconIds(int[] actionButtonIconIds) {
        this.actionButtonIconIds = actionButtonIconIds;
    }

    public PendingIntent[] getPendingIntents() {
        return this.pendingIntents;
    }

    public void setPendingIntents(PendingIntent first, PendingIntent second) {
        this.pendingIntents = new PendingIntent[]{first, second};
    }

    public String getPushChannelName() {
        return this.pushChannelName;
    }

    public String getPushChannelDescription() {
        return this.pushChannelDescription;
    }

    public void setPushChannelName(String pushChannelName) {
        this.pushChannelName = pushChannelName;
    }

    public void setPushChannelDescription(String pushChannelDescription) {
        this.pushChannelDescription = pushChannelDescription;
    }

    public int getPushChannelImportance() {
        return this.pushChannelImportance;
    }

    public void setPushChannelImportance(int pushChannelImportance) {
        this.pushChannelImportance = pushChannelImportance;
    }
}

