/*
 * Decompiled with CFR 0.152.
 */
package net.donky.core.messaging.push.ui;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.support.v4.app.NotificationCompat;
import android.text.Html;
import android.text.TextUtils;
import net.donky.core.fcm.DonkyFcmController;
import net.donky.core.messaging.push.logic.PushLogicController;
import net.donky.core.messaging.push.logic.SimplePushData;
import net.donky.core.messaging.push.ui.SimplePushUIConfiguration;

public class SystemNotificationBuilder {
    private final int notificationId;

    SystemNotificationBuilder(int notificationId) {
        this.notificationId = notificationId;
    }

    public Notification buildSimplePushUINotification(Context context, SimplePushUIConfiguration simplePushUIConfiguration, SimplePushData simplePushData, Bitmap avatar) {
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context, DonkyFcmController.getPushChannelId((Context)context)).setSmallIcon(simplePushUIConfiguration.getSmallIconId()).setContentTitle((CharSequence)simplePushData.getSenderDisplayName()).setContentText((CharSequence)Html.fromHtml((String)this.handleEmptyMessage(simplePushData.getBody()))).setVibrate(simplePushUIConfiguration.getVibratePattern()).setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)Html.fromHtml((String)this.handleEmptyMessage(simplePushData.getBody()))).setBigContentTitle((CharSequence)simplePushData.getSenderDisplayName())).setCategory(simplePushUIConfiguration.getCategory()).setPriority(simplePushUIConfiguration.getPriority()).setVisibility(simplePushUIConfiguration.getVisibility()).setSound(simplePushUIConfiguration.getSoundUri()).setColor(simplePushUIConfiguration.getIconBackgroundColor()).setTicker((CharSequence)simplePushData.getSenderDisplayName());
        if (avatar != null) {
            builder.setLargeIcon(avatar);
        }
        if (simplePushData.getButtonSets() != null) {
            SimplePushData.ButtonSet buttonSetToUse = null;
            for (SimplePushData.ButtonSet buttonSet : simplePushData.getButtonSets()) {
                if (buttonSet == null || !"Mobile".equals(buttonSet.getPlatform())) continue;
                buttonSetToUse = buttonSet;
            }
            if (buttonSetToUse != null) {
                if (buttonSetToUse.getButtonSetActions() != null) {
                    PendingIntent pendingIntent;
                    if (buttonSetToUse.getButtonSetActions().length == 2) {
                        if (Build.VERSION.SDK_INT >= 16) {
                            for (int i = 0; i < buttonSetToUse.getButtonSetActions().length; ++i) {
                                PendingIntent pendingIntent2 = PushLogicController.getInstance().createPendingIntent(buttonSetToUse.getButtonSetActions()[i], simplePushData, this.notificationId);
                                builder.addAction(simplePushUIConfiguration.getActionButtonIconIds()[i], (CharSequence)buttonSetToUse.getButtonSetActions()[i].getLabel(), pendingIntent2);
                            }
                            builder.setAutoCancel(false);
                        } else {
                            pendingIntent = PushLogicController.getInstance().createPendingIntent(buttonSetToUse.getButtonSetActions()[1], simplePushData, this.notificationId);
                            builder.setContentIntent(pendingIntent);
                            builder.setAutoCancel(true);
                        }
                    } else if (buttonSetToUse.getButtonSetActions().length == 1) {
                        pendingIntent = PushLogicController.getInstance().createPendingIntent(buttonSetToUse.getButtonSetActions()[0], simplePushData, this.notificationId);
                        builder.setContentIntent(pendingIntent);
                        builder.setAutoCancel(true);
                    }
                }
            } else {
                builder.setContentIntent(PushLogicController.getInstance().createPendingIntent(null, null, this.notificationId));
                builder.setAutoCancel(true);
            }
        } else {
            builder.setContentIntent(PushLogicController.getInstance().createPendingIntent(null, null, this.notificationId));
            builder.setAutoCancel(true);
        }
        Notification notification = builder.build();
        notification.ledARGB = context.getResources().getColor(simplePushUIConfiguration.getLedColour());
        notification.flags |= 1;
        notification.ledOnMS = simplePushUIConfiguration.getLedOnMilliseconds();
        notification.ledOffMS = simplePushUIConfiguration.getLedOffMilliseconds();
        return notification;
    }

    private String handleEmptyMessage(String message) {
        if (TextUtils.isEmpty((CharSequence)message)) {
            return "<i></i>";
        }
        return message;
    }
}

