/*
 * Decompiled with CFR 0.152.
 */
package net.donky.core.signalr;

import android.app.Application;
import android.content.Context;
import java.util.concurrent.atomic.AtomicBoolean;
import net.donky.core.DonkyCore;
import net.donky.core.DonkyException;
import net.donky.core.DonkyListener;
import net.donky.core.ModuleDefinition;
import net.donky.core.events.ApplicationStartEvent;
import net.donky.core.events.ApplicationStopEvent;
import net.donky.core.events.DonkyEventListener;
import net.donky.core.network.signalr.SignalRController;
import net.donky.core.signalr.DonkySignalRController;

public class DonkySignalR {
    private final String version = "2.0.0.1";
    private static final AtomicBoolean initialised = new AtomicBoolean(false);
    private Context context;

    private DonkySignalR() {
    }

    public static DonkySignalR getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public static void initialiseDonkySignalR(Application application, DonkyListener donkyListener) {
        DonkySignalR.getInstance().init(application, donkyListener);
    }

    private void init(Application application, DonkyListener donkyListener) {
        this.context = application.getApplicationContext();
        if (!initialised.get()) {
            try {
                DonkySignalRController.getInstance().init(application);
                DonkyCore.registerModule((ModuleDefinition)new ModuleDefinition(SignalRController.SERVICE_NAME, "2.0.0.1"));
                DonkyCore.getInstance().registerService(SignalRController.SERVICE_NAME, (Object)DonkySignalRController.getInstance());
                DonkyCore.subscribeToLocalEvent((DonkyEventListener)new DonkyEventListener<ApplicationStartEvent>(ApplicationStartEvent.class){

                    public void onDonkyEvent(ApplicationStartEvent event) {
                        DonkySignalRController.getInstance().startSignalR();
                    }
                });
                DonkyCore.subscribeToLocalEvent((DonkyEventListener)new DonkyEventListener<ApplicationStopEvent>(ApplicationStopEvent.class){

                    public void onDonkyEvent(ApplicationStopEvent event) {
                        DonkySignalRController.getInstance().stopSignalR();
                    }
                });
                initialised.set(true);
            }
            catch (Exception e) {
                DonkyException donkyException = new DonkyException("Error initialising DonkySignalR");
                donkyException.initCause((Throwable)e);
                if (donkyListener != null) {
                    donkyListener.error(donkyException, null);
                }
            }
        } else if (donkyListener != null) {
            donkyListener.success();
        }
    }

    public static boolean isInitialised() {
        return initialised.get();
    }

    private static class SingletonHolder {
        private static final DonkySignalR INSTANCE = new DonkySignalR();

        private SingletonHolder() {
        }
    }
}

