/*
 * Decompiled with CFR 0.152.
 */
package net.donky.core.signalr;

import android.app.Application;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.google.gson.internal.LinkedTreeMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.donky.core.DonkyException;
import net.donky.core.DonkyResultListener;
import net.donky.core.account.DonkyAccountController;
import net.donky.core.lifecycle.LifeCycleObserver;
import net.donky.core.logging.DLog;
import net.donky.core.model.DonkyDataController;
import net.donky.core.network.ClientNotification;
import net.donky.core.network.DonkyNetworkController;
import net.donky.core.network.ServerNotification;
import net.donky.core.network.SynchronisationHandler;
import net.donky.core.network.restapi.secured.SynchroniseResponse;
import net.donky.core.network.signalr.SignalRController;
import net.donky.core.signalr.internal.ConnectionListener;
import net.donky.core.signalr.internal.HubConnectionFactory;
import net.donky.core.signalr.internal.PushHandler;
import net.donky.core.signalr.internal.tasks.SynchronisationTask;

public class DonkySignalRController
extends SignalRController
implements PushHandler {
    private static final String NOTIFICATION_TYPE_PENDING = "NotificationPending";
    private final String KEY_TYPE = "type";
    private final String KEY_DATA = "data";
    private final String TYPE_USER_TYPING = "UserIsTyping";
    private static final int CORE_POOL_SIZE = 1;
    private static final int MAXIMUM_POOL_SIZE = 1;
    private static final int KEEP_ALIVE_TIME_SEC = 10;
    private DLog log = new DLog("DonkySignalRController");
    private final HubConnectionFactory hubConnectionFactory = new HubConnectionFactory(this, new ConnectionListener(){

        @Override
        public void notifyConnectionError(DonkyException donkyException, Map<String, String> validationErrors) {
            if (DonkySignalRController.this.isTaskInProgress && DonkySignalRController.this.synchronisationTask != null) {
                DonkySignalRController.this.synchronisationTask.notifyConnectionError(donkyException, validationErrors);
            }
        }
    });
    ThreadPoolExecutor threadPoolExecutor;
    BlockingDeque<Runnable> workQueue = new LinkedBlockingDeque<Runnable>();
    Handler mainThreadHandler = new Handler(Looper.getMainLooper());
    SynchronisationTask synchronisationTask;
    private static final Object sharedLock = new Object();
    volatile boolean isTaskInProgress;
    private static final long TIMEOUT = 1000L;

    private DonkySignalRController() {
        this.threadPoolExecutor = new ThreadPoolExecutor(1, 1, 10L, TimeUnit.SECONDS, this.workQueue);
    }

    public static DonkySignalRController getInstance() {
        return SingletonHolder.INSTANCE;
    }

    void init(Application application) {
    }

    public boolean isConnected() {
        return this.hubConnectionFactory.isConnected();
    }

    public synchronized void startSignalR() {
        if (!this.hubConnectionFactory.isConnected()) {
            this.hubConnectionFactory.startSignalR(LifeCycleObserver.getInstance().isApplicationForegrounded());
        }
    }

    public void stopSignalR() {
        this.hubConnectionFactory.stopSignalR();
    }

    public synchronized void synchronise(List<ClientNotification> clientNotificationsToSend, DonkyResultListener<SynchroniseResponse> resultListener) {
        this.log.debug("SignalR: synchronise called");
        if (!DonkyAccountController.getInstance().isRegistered()) {
            this.log.warning("SignalR: Cancel synchronisation. User not registered.");
            this.postError(new DonkyException("Cancel synchronisation. User not registered."), null, resultListener);
        } else if (DonkyAccountController.getInstance().isUserSuspended()) {
            this.log.warning("SignalR: Cancel synchronisation. User suspended.");
            this.postError(new DonkyException("Cancel synchronisation. User suspended."), null, resultListener);
        } else if (this.isTaskInProgress) {
            this.log.debug("SignalR: Synchronisation signalR task in progress.");
            this.postError(new DonkyException("Cancel synchronisation. Synchronisation signalR task in progress. Falling back to REST API."), null, resultListener);
        } else if (!this.hubConnectionFactory.isConnected()) {
            this.log.debug("SignalR: SignalR not connected. Falling back to REST API.");
            this.postError(new DonkyException("SignalR: SignalR not connected. Falling back to REST API."), null, resultListener);
        } else {
            String signalRURL = DonkyDataController.getInstance().getConfigurationDAO().getSignalRUrl();
            String authToken = DonkyDataController.getInstance().getConfigurationDAO().getAuthorisationToken();
            if (this.hubConnectionFactory.setupSignalRConnection(authToken, signalRURL, false)) {
                this.log.debug("SignalR: connection objects are ok. Invoking sync on network.");
                this.invokeSynchronise(clientNotificationsToSend, resultListener);
            } else {
                this.log.debug("SignalR: connection object was outdated. Falling back to REST API.");
                this.postError(new DonkyException("Recreating signalR connection. Falling back to REST API."), null, resultListener);
            }
        }
    }

    private void invokeSynchronise(final List<ClientNotification> clientNotificationsToSend, final DonkyResultListener<SynchroniseResponse> resultListener) {
        this.isTaskInProgress = true;
        this.threadPoolExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = sharedLock;
                synchronized (object) {
                    DonkySignalRController.this.synchronisationTask = new SynchronisationTask(DonkySignalRController.this.hubConnectionFactory, clientNotificationsToSend, new DonkyResultListener<SynchroniseResponse>(){

                        public void success(final SynchroniseResponse result) {
                            DonkySignalRController.this.log.debug("SignalR: synchronisation done " + result.toString());
                            if (DonkySignalRController.this.isTaskInProgress) {
                                DonkySignalRController.this.log.debug("SignalR: notifying core about successful synchronisation.");
                                DonkySignalRController.this.isTaskInProgress = false;
                                DonkySignalRController.this.mainThreadHandler.post(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (resultListener != null) {
                                            resultListener.success((Object)result);
                                        }
                                    }
                                });
                            } else {
                                DonkySignalRController.this.log.warning("SignalR: Not expected callback from sync.");
                            }
                        }

                        public void error(DonkyException donkyException, Map<String, String> validationErrors) {
                            DonkySignalRController.this.log.debug("SignalR: synchronisation failure");
                            if (DonkySignalRController.this.isTaskInProgress) {
                                DonkySignalRController.this.log.debug("SignalR: notifying core about synchronisation failure.");
                                DonkySignalRController.this.isTaskInProgress = false;
                                DonkySignalRController.this.postError(donkyException, validationErrors, resultListener);
                            } else {
                                DonkySignalRController.this.log.warning("SignalR: Not expected callback from sync.");
                            }
                        }
                    });
                    sharedLock.notifyAll();
                }
                DonkySignalRController.this.synchronisationTask.performTask();
            }
        });
    }

    @Override
    public void handlePush(final Object obj) {
        this.threadPoolExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = sharedLock;
                synchronized (object) {
                    try {
                        if (obj instanceof ArrayList) {
                            ArrayList combinedList = (ArrayList)obj;
                            for (Object notification : combinedList) {
                                if (!(notification instanceof LinkedTreeMap)) continue;
                                LinkedTreeMap notificationTreeMap = (LinkedTreeMap)notification;
                                ServerNotification serverNotification = new ServerNotification(notificationTreeMap);
                                String type = (String)notificationTreeMap.get((Object)"type");
                                if (DonkySignalRController.NOTIFICATION_TYPE_PENDING.equals(type)) {
                                    String notificationId = (String)notificationTreeMap.get((Object)"id");
                                    if (TextUtils.isEmpty((CharSequence)notificationId)) continue;
                                    try {
                                        serverNotification = DonkyNetworkController.getInstance().getServerNotification(notificationId);
                                        if (serverNotification != null) {
                                            SynchronisationHandler synchronisationHandler = new SynchronisationHandler(serverNotification);
                                            DonkySignalRController.this.log.debug("SignalR: serverNotification downloaded " + serverNotification.getData());
                                            synchronisationHandler.processServerNotifications(Boolean.valueOf(true));
                                            continue;
                                        }
                                        DonkySignalRController.this.log.debug("SignalR: serverNotification missing when tried to download. Falling back to full sync.");
                                        DonkyNetworkController.getInstance().synchroniseSynchronously();
                                    }
                                    catch (Exception exception) {
                                        DonkySignalRController.this.log.info("SignalR: error downloading notification");
                                    }
                                    continue;
                                }
                                try {
                                    SynchronisationHandler synchronisationHandler = new SynchronisationHandler(serverNotification);
                                    synchronisationHandler.processServerNotifications();
                                }
                                catch (Exception exception) {
                                    DonkySignalRController.this.log.info("SignalR: error procising notification directly from signalR channel");
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        DonkySignalRController.this.log.info("SignalR: error processing push");
                    }
                    sharedLock.notifyAll();
                }
            }
        });
    }

    private void postError(final DonkyException donkyException, final Map<String, String> validationErrors, final DonkyResultListener donkyListener) {
        if (donkyListener != null) {
            this.mainThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    donkyListener.error(donkyException, validationErrors);
                }
            });
        }
    }

    private static class SingletonHolder {
        private static final DonkySignalRController INSTANCE = new DonkySignalRController();

        private SingletonHolder() {
        }
    }
}

